/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.slf4j.LoggerFactory;

public class ApplicableGdsAccountsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer applicableAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNT);
        if (applicableAccountCtr != null) {
            ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNTS, Collections.singletonList(applicableAccountCtr));
            return;
        }
        FlightSearchParameters flightSearchParameters = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference specialTariffRef = (EntityReference)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SPECIAL_TARIFF);
        SpecialTariff specialTariff = null;
        if (specialTariffRef != null) {
            specialTariff = (SpecialTariff)EntityStorage.get().resolve(specialTariffRef).getEntity();
        }
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.gds.GDSConnector.RULES_TRACE").isDebugEnabled());
        proxy.setProxyType(Targets.GDS_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new GDSParametersProperties(flightSearchParameters.getRoute(), salesContext, null, null, proxy));
        proxy.setActionSet((Object)new GDSParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        HashSet<EntityContainer> res = new HashSet<EntityContainer>();
        for (EntityReference<BaseAirGdsAccount> ref : ((GDSParametersActions)proxy.getActionSet()).getApplicableGdsAccounts()) {
            EntityContainer ctr;
            if (specialTariff != null && !specialTariff.getGdsAccounts().contains(ref) || (ctr = EntityStorage.get().resolve(ref)) == null) continue;
            BaseGdsAccount entity = (BaseGdsAccount)ctr.getEntity();
            if (!(entity instanceof BaseAirGdsAccount)) {
                throw Xeption.forAdmin((String)"\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0432 \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u0445 \u0441\u0430\u0439\u0442\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043d\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0430\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u043e\u0432.", (Object[])new Object[]{ref.getCaption()});
            }
            if (!((BaseAirGdsAccount)ctr.getEntity()).isDisabled()) {
                res.add(ctr);
                continue;
            }
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d", (Object[])new Object[]{((BaseAirGdsAccount)ctr.getEntity()).getName()}));
        }
        ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNTS, res);
    }
}

