/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.FlightAndRuleProxies;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class ApplyRuleActionsToFlightProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference blankOwner;
        Boolean doNotExcludeFromResult = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.DO_NOT_EXCLUDE_FROM_RESULT);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        FlightAndRuleProxies farp = (FlightAndRuleProxies)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_AND_RULE_PROXY);
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        Flight flight = farp.getFlight();
        if (isSaveRulesTraces) {
            Object sp = ctx.getObject((Enum)IBusGdsContextKeys.SALES_POINT_FOR_RULES);
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("using rules from sales point:%s", sp));
            for (RuleProxy<FlightPropertySet, GDSParametersActions> proxy : farp.getRuleProxies().values()) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("trace of proxy:\n%s\npassengerType=%s", proxy.getTracer().getTrace(), ((FlightPropertySet)((Object)proxy.getPropertySet())).getPassengerTypeRef()));
                for (String ruleUid : proxy.getAppliedRules()) {
                    RuleSettings rs = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                    if (rs == null) continue;
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("rule %s was applied: %s", rs.getName(), rs.getRestrictionsInfoNoHtml()));
                }
                proxy.getTracer().clear(true);
            }
        }
        if (farp.getRuleProxies().values().stream().filter(rp -> ((GDSParametersActions)rp.getActionSet()).isExcludeFromResult()).findAny().isPresent()) {
            if (Boolean.TRUE.equals(doNotExcludeFromResult)) {
                if (isSaveRulesTraces) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "flight should have been excluded from result due to rules restriction but wasn't because it's already past-search phase");
                }
            } else {
                if (isSaveRulesTraces) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "flight was excluded from result due to rules restriction");
                }
                flights.remove(flight);
                ctx.putObject((Enum)IBusGdsContextKeys.SOME_FLIGHTS_EXCLUDED, (Object)Boolean.TRUE);
            }
        }
        if ((blankOwner = farp.getSingleValue(rp -> ((GDSParametersActions)rp.getActionSet()).getBlankOwner())) != null) {
            flight.setBlankOwner(blankOwner);
            if (isSaveRulesTraces) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("blank owner was set to %s", blankOwner));
            }
        }
        if (farp.getRuleProxies().values().stream().filter(rp -> ((GDSParametersActions)rp.getActionSet()).isSubsidizedTariff()).findAny().isPresent()) {
            flight.setSubsidizedTariff(true);
            if (isSaveRulesTraces) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "subsidized tariff was set to true");
            }
        }
        if (farp.getRuleProxies().values().stream().filter(rp -> ((GDSParametersActions)rp.getActionSet()).isSubsidizedTariffFlagSet()).findAny().isPresent()) {
            flight.setIgnoreContractsForSubsidizedTariffFlag(true);
        }
        if (farp.getRuleProxies().values().stream().allMatch(rp -> ((GDSParametersActions)rp.getActionSet()).isHideAdditionalFares())) {
            flight.setFlightFaresSearchDisabled(true);
        }
        for (RuleProxy<FlightPropertySet, GDSParametersActions> proxy : farp.getRuleProxies().values()) {
            GDSParametersActions actionSet = (GDSParametersActions)proxy.getActionSet();
            flight.setTimeLimit(FlightHelper.calculateTimeLimit((TimeLimitType)actionSet.getTimeLimitType(), (int)actionSet.getTimeForTimeLimit(), (Flight)flight));
            flight.getTimeLimitExpiryWarningTime().clear();
            actionSet.getWarningAboutExpiringTime().stream().map(minutes -> FlightHelper.calculateDate((Date)flight.getTimeLimit(), (int)minutes, (boolean)false)).filter(Objects::nonNull).forEach(date -> flight.getTimeLimitExpiryWarningTime().add(FlightHelper.buildExpiryWarningTime((Date)date)));
        }
    }
}

