/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ApplyRuleActionsToReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GDSParametersActions actions = (GDSParametersActions)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List<Product> products = GDSHelper.getProducts(reservation);
        if (!products.isEmpty()) {
            Segment seg0 = (Segment)((SegmentTariff)products.get(0).getSegmentTariffs().get(0)).getSegments().get(0);
            Date newCalculatedTimeLimit = FlightHelper.calculateTimeLimit((TimeLimitType)actions.getTimeLimitType(), (int)actions.getTimeForTimeLimit(), (Date)reservation.getPqTimeLimit(), (DictionaryReference)seg0.getDepartureLocation(), (Date)seg0.getStartDate(), (Date)Optional.ofNullable(reservation.getResDate()).orElse(new Date()));
            Date previousTimeLimit = reservation.getTimeLimit();
            if (!reservation.isManualTimeLimit() && (previousTimeLimit == null || newCalculatedTimeLimit.before(previousTimeLimit))) {
                reservation.setTimeLimit(newCalculatedTimeLimit);
                reservation.getTimeLimitExpiryWarningTime().clear();
                actions.getWarningAboutExpiringTime().stream().map(minutes -> FlightHelper.calculateDate((Date)reservation.getTimeLimit(), (int)minutes, (boolean)false)).filter(Objects::nonNull).forEach(date -> reservation.getTimeLimitExpiryWarningTime().add(FlightHelper.buildExpiryWarningTime((Date)date)));
            }
        }
        products.forEach(prod -> {
            prod.setSubsidizedTariff(actions.isSubsidizedTariff());
            prod.setIgnoreContractsForSubsidizedTariffFlag(actions.isSubsidizedTariffFlagSet());
        });
    }
}

