/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class ApplyRulesToProxiesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List proxies = (List)ctx.getObject((Enum)IBusGdsContextKeys.RULE_PROXIES);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces() && builder != null;
        EntityReference salesPointRef = (EntityReference)ctx.getObject((Enum)IBusGdsContextKeys.SALES_POINT_FOR_RULES);
        String referenceSource = "salesPoint";
        if (ctx.hasObject((Enum)IBusGdsContextKeys.CUSTOM_ENTITY_REF_TO_RULES)) {
            salesPointRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CUSTOM_ENTITY_REF_TO_RULES);
            referenceSource = "source -";
        }
        if (proxies != null && proxies.size() > 0) {
            if (isSaveRulesTraces) {
                builder.traceGlobalLogic(MessageType.MESSAGE, String.format("using rules from %s %s", referenceSource, salesPointRef));
            }
            RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
            RuleEngine.applyRules((List)proxies, (RuleSet)rules);
            if (isSaveRulesTraces && ((RuleProxy)proxies.get(0)).getPropertySet() instanceof FlightPropertySet) {
                for (RuleProxy proxy : proxies) {
                    for (String ruleUid : proxy.getAppliedRules()) {
                        RuleSettings rs = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                        if (rs == null) continue;
                        builder.traceFlightLogic((BaseEntity)((FlightPropertySet)((Object)proxy.getPropertySet())).getFlight(), MessageType.MESSAGE, String.format("rule %s \"%s\" was applied: %s", rules.getRules().indexOf(rs) + 1, rs.getName(), rs.getRestrictionsInfoNoHtml()));
                        builder.registerAppliedRule((BaseEntity)((FlightPropertySet)((Object)proxy.getPropertySet())).getFlight(), salesPointRef, rs);
                    }
                }
            }
        }
    }
}

