/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.midoffice.model.BaseReservationCreationParameters;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.helper.SegmentUpdateHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CheckBookingFlightUpdatedAdvice
extends BaseAdvice {
    private static final String DATA_KEY = CheckBookingFlightUpdatedAdvice.class.getName().concat(".data");

    public void before(MessageContext ctx) throws Exception {
        BaseReservationCreationParameters parameters = (BaseReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Flight flight = CheckBookingFlightUpdatedAdvice.getFlight(parameters);
        if (flight == null) {
            return;
        }
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        ctx.putObject(DATA_KEY, SegmentUpdateHelper.getDataToCompare(flight, travellers));
    }

    public void after(MessageContext ctx) throws Exception {
        Map<String, Set<List<SegmentUpdateHelper.SegmentEssentials>>> newData;
        BaseReservationCreationParameters parameters = (BaseReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        if (CheckBookingFlightUpdatedAdvice.getFlight(parameters) == null) {
            return;
        }
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (reservation == null) {
            return;
        }
        Map oldData = (Map)ctx.removeObject(DATA_KEY);
        if (!oldData.equals(newData = SegmentUpdateHelper.getDataToCompare(reservation))) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_UPDATED, (Object)Boolean.TRUE);
        }
    }

    private static Flight getFlight(BaseReservationCreationParameters parameters) {
        return Optional.of(parameters).filter(GdsReservationCreationParameters.class::isInstance).map(GdsReservationCreationParameters.class::cast).map(GdsReservationCreationParameters::getFlight).orElse(null);
    }
}

