/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineActionSet;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineRulesHelper;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineTargets;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.SegmentHelper;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.exception.NumberOfSeatsDoesNotEqualNumberOfPartiesInSegmentException;
import com.gridnine.xtrip.server.gds.rules.proxy.GdsProductPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CheckChosenAllSeatsBySegmentOnCancelProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection products = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        Collection refundProducts = BookingStreamHelper.getProductsStream(products.stream(), Product.class).collect(Collectors.toList());
        List seatsRefundProducts = refundProducts.stream().filter(product -> product.getMcoCategory() == MCOCategory.SEAT_RESERVATION).collect(Collectors.toList());
        if (seatsRefundProducts.size() == 0) {
            return;
        }
        RuleSet ruleSet = CommonAirlineRulesHelper.getCommonAirlineSettings().getRuleSet();
        if (ruleSet == null || ruleSet.isEmpty()) {
            return;
        }
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyType(CommonAirlineTargets.UNSELL_RULES.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new GdsProductPropertySet(proxy));
        ((GdsProductPropertySet)((Object)proxy.getPropertySet())).init((Product)seatsRefundProducts.get(0));
        proxy.setActionSet((Object)new CommonAirlineActionSet());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
        if (((CommonAirlineActionSet)proxy.getActionSet()).isPartialAncillaryCancelAllowed() != null && ((CommonAirlineActionSet)proxy.getActionSet()).isPartialAncillaryCancelAllowed().booleanValue()) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.PARTIAL_ANCILLARY_CANCEL_ALLOWED, (Object)true);
            return;
        }
        Reservation res = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List<Product> resProducts = GDSHelper.getProducts(res, ProductCategory.MCO).stream().filter(product -> product.getMcoCategory() == MCOCategory.SEAT_RESERVATION).collect(Collectors.toList());
        Map<Segment, List<Product>> reservedProductsBySegment = this.getProductsBySegmentMap(resProducts);
        Map<Segment, List<Product>> refundProductsBySegment = this.getProductsBySegmentMap(refundProducts);
        for (Map.Entry<Segment, List<Product>> refundEntry : refundProductsBySegment.entrySet()) {
            for (Map.Entry<Segment, List<Product>> reservedEntry : reservedProductsBySegment.entrySet()) {
                if (!SegmentHelper.equals((Segment)refundEntry.getKey(), (Segment)reservedEntry.getKey(), (boolean)false) || refundEntry.getValue().size() == reservedEntry.getValue().size()) continue;
                throw new NumberOfSeatsDoesNotEqualNumberOfPartiesInSegmentException();
            }
        }
    }

    private Map<Segment, List<Product>> getProductsBySegmentMap(Collection<Product> products) {
        HashMap<Segment, List<Product>> result = new HashMap<Segment, List<Product>>();
        for (Product product : products) {
            for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
                for (Segment segment : segmentTariff.getSegments()) {
                    Map.Entry<Segment, List<Product>> entry = this.findEntryBySegment(result, segment);
                    if (entry == null) {
                        ArrayList<Product> productList = new ArrayList<Product>();
                        productList.add(product);
                        result.put(segment, productList);
                        continue;
                    }
                    entry.getValue().add(product);
                }
            }
        }
        return result;
    }

    private Map.Entry<Segment, List<Product>> findEntryBySegment(Map<Segment, List<Product>> map, Segment segment) {
        for (Map.Entry<Segment, List<Product>> entry : map.entrySet()) {
            if (!SegmentHelper.equals((Segment)entry.getKey(), (Segment)segment, (boolean)false)) continue;
            return entry;
        }
        return null;
    }
}

