/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.helper.SegmentUpdateHelper;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CheckReservationUpdatedAdvice
extends BaseAdvice {
    private static final String DATA_KEY = CheckReservationUpdatedAdvice.class.getName().concat(".data");

    public void before(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (!CheckReservationUpdatedAdvice.isAviaReservation(reservation)) {
            return;
        }
        ctx.putObject(DATA_KEY, SegmentUpdateHelper.getDataToCompare(reservation));
    }

    public void after(MessageContext ctx) throws Exception {
        Map<String, Set<List<SegmentUpdateHelper.SegmentEssentials>>> newData;
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (!CheckReservationUpdatedAdvice.isAviaReservation(reservation)) {
            return;
        }
        Map oldData = (Map)ctx.removeObject(DATA_KEY);
        if (!oldData.equals(newData = SegmentUpdateHelper.getDataToCompare(reservation))) {
            ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION_UPDATED, (Object)Boolean.TRUE);
        }
    }

    private static boolean isAviaReservation(Reservation reservation) {
        return reservation.getProducts().get(0) instanceof Product;
    }
}

