/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.CollectedContractData;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CollectSeparateBspContractsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map contractsMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean trace = builder != null && gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        HashMap<EntityReference, List> suppliersMap = new HashMap<EntityReference, List>();
        HashMap<Flight, EntityReference> reversedSupplierMaps = new HashMap<Flight, EntityReference>();
        Date now = new Date();
        HashMap<Flight, CollectedContractData> result = new HashMap<Flight, CollectedContractData>();
        ctx.putObject((Enum)IBusGdsContextKeys.SEPARATE_BSP_CONTRACTS_MAP, result);
        block0: for (Map.Entry entry : contractsMap.entrySet()) {
            Flight flight = (Flight)entry.getKey();
            for (Map.Entry contractEntry : ((Map)entry.getValue()).entrySet()) {
                if (GeneralProductHelper.getContractType((EntityReference)((EntityReference)contractEntry.getKey())) != ContractType.VENDOR) continue;
                CollectedContractData contractData = (CollectedContractData)contractEntry.getValue();
                for (EntityContainer contractCtr : contractData.getContractContainers()) {
                    Contract contract = (Contract)contractCtr.getEntity();
                    if (contract.isNewModel()) {
                        if (!MiscUtil.equals((Object)contractData.getCustomer(), (Object)contract.getCustomer()) || !MiscUtil.isBetween((Date)contract.getStartDate(), (Date)contract.getEndDate(), (Date)now) || !contract.isUseSeparateBSPContract()) continue;
                        EntityReference supplier = ((Contract)contractCtr.getEntity()).getSupplier();
                        List flights = suppliersMap.computeIfAbsent(supplier, k -> new ArrayList());
                        flights.add(flight);
                        reversedSupplierMaps.put(flight, supplier);
                        continue block0;
                    }
                    for (ContractCustomerInfo customerInfo : ((Contract)contractCtr.getEntity()).getCustomers()) {
                        if (!MiscUtil.equals((Object)contractData.getCustomer(), (Object)customerInfo.getCustomer()) || !MiscUtil.isBetween((Date)customerInfo.getStartDate(), (Date)customerInfo.getEndDate(), (Date)now) || !customerInfo.isUseSeparateBSPContract()) continue;
                        EntityReference supplier = ((Contract)contractCtr.getEntity()).getSupplier();
                        ArrayList<Flight> flights = (ArrayList<Flight>)suppliersMap.get(supplier);
                        if (flights == null) {
                            flights = new ArrayList<Flight>();
                            suppliersMap.put(supplier, flights);
                        }
                        flights.add(flight);
                        reversedSupplierMaps.put(flight, supplier);
                        continue block0;
                    }
                }
            }
        }
        if (suppliersMap.isEmpty()) {
            return;
        }
        HashMap<EntityReference, CollectedContractData> bspContracts = new HashMap<EntityReference, CollectedContractData>();
        EntityContainer bspCtr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)"BSP");
        if (bspCtr == null) {
            if (trace) {
                builder.traceGlobalLogic(MessageType.WARNING, "\u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043f\u0440\u043e\u0444\u0438\u043b\u044c BSP");
            }
            return;
        }
        EntityReference bspRef = bspCtr.toReference();
        for (EntityReference supplier : suppliersMap.keySet()) {
            CollectedContractData collectData = this.collectData((EntityReference<Organization>)supplier, (EntityReference<Organization>)bspRef);
            if (trace) {
                if (collectData.getContractContainers().isEmpty()) {
                    builder.traceGlobalLogic(MessageType.WARNING, String.format("\u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 %s \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 BSP", supplier));
                } else {
                    builder.traceGlobalLogic(MessageType.MESSAGE, String.format("\u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 %s \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b \u0441 BSP: %s", supplier, collectData.getContractContainers().stream().map(ctr -> ((Contract)ctr.getEntity()).toString()).collect(Collectors.toList())));
                }
            }
            bspContracts.put(supplier, collectData);
        }
        for (Flight flight : contractsMap.keySet()) {
            EntityReference supplierRef = (EntityReference)reversedSupplierMaps.get(flight);
            CollectedContractData contractData = (CollectedContractData)bspContracts.get(supplierRef);
            if (contractData == null || contractData.getContractContainers().isEmpty()) continue;
            result.put(flight, contractData);
        }
    }

    private CollectedContractData collectData(EntityReference<Organization> supplier, EntityReference<Organization> bspRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.VENDOR));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), supplier));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), bspRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.vendor.name(), bspRef));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)new Date()))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)new Date()))}));
        query.getCriteria().getOrders().put(ContractCustomerIndex.Property.issueDate.name(), SortOrder.DESC);
        query.getPreferredProperties().add(ContractCustomerIndex.Property.name.name());
        List data = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        ArrayList<EntityContainer> contracts = new ArrayList<EntityContainer>(data.size());
        for (ContractCustomerIndex item : data) {
            EntityContainer ctr = EntityStorage.get().resolve(item.getSource());
            if (ctr == null) continue;
            contracts.add(ctr);
        }
        CollectedContractData result = new CollectedContractData();
        result.setSupplier(bspRef);
        result.setCustomer(supplier);
        result.getContractContainers().addAll(contracts);
        return result;
    }
}

