/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ContextKeyMcoProductsTargetProvider
extends BaseTargetsProvider<Product> {
    private String key;
    private Set<MCOCategory> mcoCategories;

    public void configure(Map<String, String> parameters) {
        this.key = IbusConfigurationHelper.getMandatoryParameter(parameters, (String)"key");
        String categories = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"mcoCategories");
        if (categories != null) {
            this.mcoCategories = Arrays.stream(categories.split(",")).map(category -> MCOCategory.valueOf((String)category)).collect(Collectors.toSet());
        }
    }

    public Collection<Product> getTargets(MessageContext ctx) throws Exception {
        Collection mcoProducts = (Collection)ctx.getObject(this.key);
        if (this.mcoCategories == null) {
            return mcoProducts;
        }
        return mcoProducts.stream().filter(prod -> this.mcoCategories.contains(prod.getMcoCategory())).collect(Collectors.toList());
    }
}

