/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CreateRefundProductsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        this.refundReservation(reservation, unsellFinanceDetails);
    }

    private void refundReservation(Reservation reservation, UnsellFinanceDetails unsellFinanceDetails) throws Exception {
        HashMap<String, Product> productMap = new HashMap<String, Product>();
        for (Product product : GDSHelper.getProducts(reservation, ProductCategory.AIR, ProductCategory.MCO)) {
            if (product.getStatus() != ProductStatus.SELL || product.getNextProduct() != null) continue;
            productMap.put(product.getUid(), product);
        }
        for (Map.Entry entry : unsellFinanceDetails.getGdsDetails().entrySet()) {
            if (!productMap.containsKey(entry.getKey())) continue;
            this.refundProduct((Product)productMap.get(entry.getKey()), (GdsProductRefexFinanceDetails)entry.getValue());
        }
    }

    private void refundProduct(Product product, GdsProductRefexFinanceDetails details) throws Exception {
        Product refundProd = new Product();
        AirProductHelper.copy((Product)product, (Product)refundProd, (boolean)false);
        product.getReservation().getProducts().add(refundProd);
        product.setNextProduct(refundProd);
        refundProd.setPreviousProduct(product);
        refundProd.setIssueDate(new Date());
        refundProd.setStatus(ProductStatus.REFUND);
        refundProd.setEndorsement(null);
        refundProd.setFareCalculationData(null);
        refundProd.setChecked(false);
        refundProd.setContractRulesApplied(false);
        refundProd.setTotalVendorEquivalentVatAmount(null);
        refundProd.setVendorVatCalculated(false);
        refundProd.setPenalty(details.getPenalty());
        this.updateFares(refundProd, details);
        this.updateTaxes(refundProd, details);
        refundProd.setCompleted(false);
        refundProd.getObFees().clear();
        refundProd.getVendorVatDetalization().getComponents().clear();
        refundProd.getVendorVatDetalization().setDetalized(false);
    }

    private void updateFares(Product product, GdsProductRefexFinanceDetails details) {
        product.getFares().clear();
        ProductFare fare = new ProductFare();
        fare.setEquivalentFare(details.getEquivalentFare());
        fare.setBaseFare(details.getBaseFare());
        product.getFares().add(fare);
    }

    private void updateTaxes(Product product, GdsProductRefexFinanceDetails details) {
        product.getTaxes().clear();
        for (SimpleTax st : details.getTaxes()) {
            Tax tax = new Tax();
            tax.setCode(st.getCode());
            tax.setEquivalentAmount(st.getAmount());
            product.getTaxes().add(tax);
        }
    }
}

