/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class CreateReservationAncillaryFeesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map reservationAncillaryFees = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_ANCILLARY_FEES);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map virtualProductsMap = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.VIRTUAL_PRODUCTS_MAP);
        List ancillaryFees = (List)reservationAncillaryFees.get(reservation);
        if (ancillaryFees == null || ancillaryFees.isEmpty()) {
            return;
        }
        Product mainProduct = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        for (AncillaryFee fee : ancillaryFees) {
            MCOCategory mcoCategory;
            Product virtualProduct = AirProductHelper.clone((Product)mainProduct, (boolean)true);
            virtualProduct.setContractRulesApplied(false);
            virtualProduct.setChecked(false);
            virtualProduct.setProductCategory(ProductCategory.MCO);
            AncillaryFeeType type = fee.getType();
            virtualProduct.setMcoCategory(MCOCategory.PENALTY);
            AncillaryFeeDescription ancillaryFeeDescription = (AncillaryFeeDescription)DictionaryCache.get().resolveReference(fee.getDescription());
            if (type == null && ancillaryFeeDescription != null) {
                type = ancillaryFeeDescription.getType();
            }
            if (type != null && (mcoCategory = GdsDictHelper.convertToMcoCategory((AncillaryFeeType)type)) != null) {
                virtualProduct.setMcoCategory(mcoCategory);
            }
            virtualProduct.getTaxes().clear();
            virtualProduct.getFares().clear();
            AirProductHelper.getContractRelations((Product)virtualProduct).clear();
            virtualProduct.setPassengerType(fee.getPassengerType());
            AirProductHelper.setEquivalentFare((Product)virtualProduct, (BigDecimal)fee.getEquivalentAmount());
            AirProductHelper.setBaseFare((Product)virtualProduct, (Money)fee.getBaseAmount());
            virtualProductsMap.put(fee, virtualProduct);
        }
    }
}

