/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.mail.MailAddress;
import com.gridnine.xtrip.common.model.mail.MailDocument;
import com.gridnine.xtrip.common.model.mail.MailPart;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.mail.MailSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomDebugProcessor
extends BaseProcessor {
    private String step;

    public void configure(Map<String, String> params) {
        this.step = params.get("step");
    }

    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        boolean accept = false;
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        String subject = null;
        EntityReference subagency = sc.getSubagency();
        if (flight.getGds() != null && flight.getGds().name().contains("SABRE") && subagency != null && subagency.getCaption() != null && subagency.getCaption().toLowerCase().contains("\u043c\u044d\u0432\u0435\u0440\u0438\u043a")) {
            accept = true;
            subject = "\u041e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435, \u041c\u042d\u0412\u0415\u0420\u0418\u041a_\u041f\u0420\u0422\u0411: ";
        } else if (sc.getAgent() != null && sc.getAgent().getCaption() != null && sc.getAgent().getCaption().toLowerCase().contains("\u043a\u0430\u0448\u0438\u043d\u0430")) {
            accept = true;
            subject = "\u041e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435, \u0410\u0433\u0435\u043d\u0442 \u041a\u0410\u0428\u0418\u041d\u0410: ";
        }
        if (accept) {
            MailDocument mailDoc = new MailDocument();
            MailAddress fromAddress = new MailAddress();
            fromAddress.setAddress("support@gridnine.com");
            mailDoc.setFrom(fromAddress);
            MailAddress toAddress = new MailAddress();
            toAddress.setAddress("nikolay.kostyukovich.ctr@gridnine.com");
            mailDoc.getTo().addAll(Arrays.asList(toAddress));
            mailDoc.setSubject(subject + this.step);
            MailPart mailPart = new MailPart();
            mailPart.setContentType(ContentType.TEXT);
            StringBuilder buf = new StringBuilder();
            buf.append("\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f: " + new SimpleDateFormat("dd.MM.yyyy hh:mm:ss").format(new Date()) + "; ");
            EntityReference agency = (EntityReference)ctx.getObject((Enum)IBusGdsContextKeys.AGENCY);
            if (agency != null) {
                buf.append("\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e: " + agency.toString() + "; ");
            }
            buf.append("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f: " + this.step + "; ");
            mailPart.setData(buf.toString().getBytes("utf-8"));
            mailDoc.setBody(mailPart);
            mailDoc.getAttachments().add(this.buildAttachment("flight.xml", (BaseEntity)flight));
            mailDoc.getAttachments().add(this.buildAttachment("salesContext.xml", (BaseEntity)sc));
            MailSender sender = (MailSender)Environment.getPublished(MailSender.class);
            sender.send(mailDoc);
        }
    }

    private MailPart buildAttachment(String name, BaseEntity entity) throws Exception {
        MailPart res = new MailPart();
        res.setContentType(ContentType.XML);
        res.setName(name);
        Document doc = DocumentBuilderHelper.newDocument();
        Element el = doc.createElement("entity");
        entity.toXML(el);
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        try {
            XUtil.newTransformer().transform(new DOMSource(el), new StreamResult(strm));
            res.setData(strm.toByteArray());
        }
        catch (Exception e) {
            throw new IOException("failed serializing element, error - " + e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)strm);
        }
        return res;
    }
}

