/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DecomposeReservationAncillaryFeesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation;
        Map reservationFees = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_ANCILLARY_FEES);
        List ancillaryFees = (List)reservationFees.get(reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION));
        if (ancillaryFees == null || ancillaryFees.isEmpty()) {
            return;
        }
        Map<DictionaryReference, List<AncillaryFee>> ancillaryFeesByPassengerTypes = ancillaryFees.stream().filter(AncillaryFee.class::isInstance).map(AncillaryFee.class::cast).collect(Collectors.groupingBy(AncillaryFee::getPassengerType));
        HashMap productFees = new HashMap();
        for (Product product : AirProductHelper.getAirProductsList((Reservation)reservation)) {
            List<AncillaryFee> passengerTypeFees = ancillaryFeesByPassengerTypes.get(product.getPassengerType());
            if (!CollectionUtil.isNotEmpty(passengerTypeFees)) continue;
            ArrayList<AncillaryFee> fees = new ArrayList<AncillaryFee>();
            for (AncillaryFee fee : passengerTypeFees) {
                AncillaryFee productFee = (AncillaryFee)XCloneHelper.clone((XCloneable)fee, (boolean)true);
                Collection mcoProducts = AirProductHelper.getMcoByRelatedProduct((Product)product);
                int exists = (int)mcoProducts.stream().filter(mco -> mco.getStatus() == ProductStatus.BOOKING).filter(mco -> MiscUtil.equals((Object)mco.getAncillaryFeeDescription(), (Object)fee.getDescription())).count();
                productFee.setQuantity(Integer.valueOf(exists));
                fees.add(productFee);
            }
            productFees.put(product, fees);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.PRODUCT_ANCILLARY_FEES, productFees);
    }
}

