/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsCapabilities;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class EnforceFlightSearchParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (flights == null || flights.isEmpty()) {
            return;
        }
        FlightSearchParameters parameters = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        GdsCapabilities gdsCapabilities = (GdsCapabilities)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_CAPABILITIES);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GdsTracingItemBuilder builder = isSaveRulesTraces ? (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER) : null;
        boolean needEnforceRouteSegmentAirline = !gdsCapabilities.isSearchRouteSegmentAirlineSupported() && EnforceFlightSearchParametersProcessor.hasSearchRouteSegmentAirline(parameters);
        boolean needEnforceRouteSegmentFlightNumber = !gdsCapabilities.isSearchRouteSegmentFlightNumberSupported() && EnforceFlightSearchParametersProcessor.hasSearchRouteSegmentFlightNumber(parameters);
        Iterator it = flights.iterator();
        while (it.hasNext()) {
            Flight flight = (Flight)it.next();
            flight.setSearchParameters(parameters);
            if (!parameters.getFlightNumbers().isEmpty() && !EnforceFlightSearchParametersProcessor.matchesFlightNumbers(flight, parameters)) {
                it.remove();
                if (builder == null) continue;
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "excluded flight: not matches by flightNumbers");
                continue;
            }
            if (needEnforceRouteSegmentAirline && !EnforceFlightSearchParametersProcessor.matchesRouteSegmentAirline(flight, parameters)) {
                it.remove();
                if (builder == null) continue;
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "excluded flight: not matches route segment airline");
                continue;
            }
            if (needEnforceRouteSegmentFlightNumber && !EnforceFlightSearchParametersProcessor.matchesRouteSegmentFlightNumber(flight, parameters)) {
                it.remove();
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "excluded flight: not matches route segment flightNumber");
                }
            }
            if (!parameters.getPreferredAirlines().isEmpty() && !EnforceFlightSearchParametersProcessor.matchesPreferredAirlines(flight, parameters)) {
                it.remove();
                if (builder == null) continue;
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "excluded flight: not matches preferred airlines");
                continue;
            }
            String mes = EnforceFlightSearchParametersProcessor.checkTimeRestriction(flight, parameters);
            if (!TextUtil.nonBlank((String)mes)) continue;
            it.remove();
            if (builder == null) continue;
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, mes);
        }
    }

    private static boolean hasSearchRouteSegmentAirline(FlightSearchParameters parameters) {
        return parameters.getRoute().stream().anyMatch(rs -> rs.getAirline() != null && rs.getFlightNumber() == null);
    }

    private static boolean matchesRouteSegmentAirline(Flight flight, FlightSearchParameters parameters) {
        List legs = FlightHelper.getFlightLegs((Flight)flight);
        for (int i = 0; i < legs.size(); ++i) {
            DictionaryReference airline = ((RouteSegment)parameters.getRoute().get(i)).getAirline();
            if (airline == null || !((List)legs.get(i)).stream().anyMatch(fs -> !airline.equals((Object)fs.getAirline()))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSearchRouteSegmentFlightNumber(FlightSearchParameters parameters) {
        return parameters.getRoute().stream().anyMatch(rs -> rs.getAirline() != null && rs.getFlightNumber() != null);
    }

    private static boolean matchesRouteSegmentFlightNumber(Flight flight, FlightSearchParameters parameters) {
        List legs = FlightHelper.getFlightLegs((Flight)flight);
        for (int i = 0; i < legs.size(); ++i) {
            RouteSegment rs = (RouteSegment)parameters.getRoute().get(i);
            DictionaryReference airline = rs.getAirline();
            String flightNumber = rs.getFlightNumber();
            if (airline == null || flightNumber == null || !((List)legs.get(i)).stream().anyMatch(fs -> !airline.equals((Object)fs.getAirline()) || !flightNumber.equals(fs.getFlightNumber()))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesFlightNumbers(Flight flight, FlightSearchParameters parameters) {
        return flight.getSegmentTariffs().stream().map(FlightSegmentTariff::getSegments).flatMap(Collection::stream).anyMatch(fs -> EnforceFlightSearchParametersProcessor.matchesFlightNumber(fs, parameters));
    }

    private static boolean matchesFlightNumber(FlightSegment fs, FlightSearchParameters parameters) {
        return parameters.getFlightNumbers().stream().anyMatch(qfn -> MiscUtil.equals((Object)fs.getFlightNumber(), (Object)qfn.getFlightNumber()) && (qfn.getAirline() == null || qfn.getAirline().equals((Object)fs.getAirline())));
    }

    private static boolean matchesPreferredAirlines(Flight flight, FlightSearchParameters parameters) {
        return FlightHelper.getSegments((Flight)flight).stream().allMatch(fs -> parameters.getPreferredAirlines().contains(fs.getAirline()));
    }

    private static String checkTimeRestriction(Flight flight, FlightSearchParameters fsp) {
        List flightLegs = FlightHelper.getFlightLegs((Flight)flight);
        for (int ind = 0; ind < fsp.getRoute().size() && ind < flightLegs.size(); ++ind) {
            int minutes;
            RouteSegment routeSegment = (RouteSegment)fsp.getRoute().get(ind);
            List flightSegments = (List)flightLegs.get(ind);
            FlightSegment firstSegment = (FlightSegment)flightSegments.get(0);
            FlightSegment lastSegment = (FlightSegment)flightSegments.get(flightSegments.size() - 1);
            if (routeSegment.getDepartureTimeBegin() != null && (minutes = MiscUtil.getMinutes((Date)firstSegment.getDateBegin())) < routeSegment.getDepartureTimeBegin()) {
                return String.format("\u0423 \u043f\u043b\u0435\u0447\u0430 %s \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u043b\u0435\u0442\u0430 %s (\u043c\u0438\u043d) \u043c\u0435\u043d\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0438\u043b\u044c\u0442\u0440\u0430 %s", EnforceFlightSearchParametersProcessor.getLegInfo(routeSegment), minutes, routeSegment.getDepartureTimeBegin());
            }
            if (routeSegment.getDepartureTimeEnd() != null && (minutes = MiscUtil.getMinutes((Date)firstSegment.getDateBegin())) > routeSegment.getDepartureTimeEnd()) {
                return String.format("\u0423 \u043f\u043b\u0435\u0447\u0430 %s \u0432\u0440\u0435\u043c\u044f \u0432\u044b\u043b\u0435\u0442\u0430 %s (\u043c\u0438\u043d) \u0431\u043e\u043b\u044c\u0448\u0435\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0438\u043b\u044c\u0442\u0440\u0430 %s", EnforceFlightSearchParametersProcessor.getLegInfo(routeSegment), minutes, routeSegment.getDepartureTimeEnd());
            }
            if (routeSegment.getArrivalTimeBegin() != null && (minutes = MiscUtil.getMinutes((Date)lastSegment.getDateBegin())) < routeSegment.getArrivalTimeBegin()) {
                return String.format("\u0423 \u043f\u043b\u0435\u0447\u0430 %s \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u043b\u0435\u0442\u0430 %s (\u043c\u0438\u043d) \u043c\u0435\u043d\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0438\u043b\u044c\u0442\u0440\u0430 %s", EnforceFlightSearchParametersProcessor.getLegInfo(routeSegment), minutes, routeSegment.getArrivalTimeBegin());
            }
            if (routeSegment.getArrivalTimeEnd() == null || (minutes = MiscUtil.getMinutes((Date)firstSegment.getDateBegin())) <= routeSegment.getArrivalTimeEnd()) continue;
            return String.format("\u0423 \u043f\u043b\u0435\u0447\u0430 %s \u0432\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u043b\u0435\u0442\u0430 %s (\u043c\u0438\u043d) \u0431\u043e\u043b\u044c\u0448\u0435\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0444\u0438\u043b\u044c\u0442\u0440\u0430 %s", EnforceFlightSearchParametersProcessor.getLegInfo(routeSegment), minutes, routeSegment.getArrivalTimeEnd());
        }
        return null;
    }

    private static String getLegInfo(RouteSegment routeSegment) {
        return routeSegment.getLocationBegin().getCode() + "-" + routeSegment.getLocationEnd().getCode();
    }
}

