/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.GeoLocationHelper;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.server.gds.ibus.FlightSearchParametersValidator;
import java.util.Date;
import java.util.List;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class ExchangeFlightSearchParametersValidator
extends FlightSearchParametersValidator {
    @Override
    protected void validateRouteSegments(List<RouteSegment> route) {
        LocalDate now = LocalDate.now();
        RouteSegment lastRs = null;
        for (RouteSegment rs : route) {
            Date date;
            boolean locationBeginValid = this.validate((DictionaryReference<GeoLocation>)rs.getLocationBegin(), rs.getValidationContext().getLocationBeginValidationMessages());
            boolean locationEndValid = this.validate((DictionaryReference<GeoLocation>)rs.getLocationEnd(), rs.getValidationContext().getLocationEndValidationMessages());
            if (locationBeginValid && locationEndValid) {
                GeoLocation cityBegin = GeoLocationHelper.getCity((DictionaryReference)rs.getLocationBegin());
                GeoLocation cityEnd = GeoLocationHelper.getCity((DictionaryReference)rs.getLocationEnd());
                if (cityBegin.getCode().equals(cityEnd.getCode())) {
                    rs.getValidationContext().getLocationBeginValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
                    rs.getValidationContext().getLocationEndValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
                }
            }
            if ((date = rs.getDate()) == null) {
                rs.getValidationContext().getDateValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            } else {
                LocalDate dt = new LocalDate(date.getTime());
                if (Days.daysBetween((ReadablePartial)now, (ReadablePartial)dt).getDays() > 362) {
                    rs.getValidationContext().getDateValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteDateTooLate());
                }
                if (lastRs != null && lastRs.getDate() != null && dt.isBefore((ReadablePartial)new LocalDate((Object)lastRs.getDate()))) {
                    lastRs.getValidationContext().getDateValidationMessages().add(GdsValidationMessages.getWrongDate());
                    rs.getValidationContext().getDateValidationMessages().add(GdsValidationMessages.getWrongDate());
                }
            }
            if (rs.getDepartureTimeBegin() != null && rs.getDepartureTimeEnd() != null) {
                LocalTime timeBegin = LocalTime.fromMillisOfDay((long)((long)rs.getDepartureTimeBegin().intValue() * 60000L));
                LocalTime timeEnd = LocalTime.fromMillisOfDay((long)((long)rs.getDepartureTimeEnd().intValue() * 60000L));
                if (!timeEnd.isAfter((ReadablePartial)timeBegin)) {
                    rs.getValidationContext().getDepartureTimeBeginValidationMessages().add(GdsValidationMessages.getWrongDate());
                    rs.getValidationContext().getDepartureTimeEndValidationMessages().add(GdsValidationMessages.getWrongDate());
                }
            }
            lastRs = rs;
        }
    }
}

