/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineCityInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FilterGdsAccountsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Set<Object> accounts = null;
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        if (accountCtr != null) {
            SpecialTariff specialTariff;
            EntityReference specialTariffRef = (EntityReference)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SPECIAL_TARIFF);
            if (specialTariffRef != null && !(specialTariff = (SpecialTariff)EntityStorage.get().resolve(specialTariffRef).getEntity()).getGdsAccounts().contains(accountCtr.toReference())) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u0441\u043f\u0435\u0446. \u0442\u0430\u0440\u0438\u0444\u0430 {0} \u043f\u043e\u0438\u0441\u043a \u0432 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {1} \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d", (Object[])new Object[]{specialTariff.getName(), ((BaseAirGdsAccount)accountCtr.getEntity()).getName()}));
                accounts = Collections.emptySet();
            }
            if (accounts == null) {
                accounts = new HashSet<EntityContainer>(1);
                accounts.add(accountCtr);
            }
        }
        if (accounts == null) {
            accounts = (HashSet<EntityContainer>)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNTS);
        }
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        Iterator iterator = accounts.iterator();
        while (iterator.hasNext()) {
            EntityContainer acCtr = (EntityContainer)iterator.next();
            if (!((BaseAirGdsAccount)acCtr.getEntity()).isSearchCityFilterEnabled() || ((BaseAirGdsAccount)acCtr.getEntity()).getSearchCityFilterAirline() == null) continue;
            AirlineCityInfo aci = GDSHelper.getAirlineCityInfo((DictionaryReference<Airline>)((BaseAirGdsAccount)acCtr.getEntity()).getSearchCityFilterAirline());
            if (aci == null) {
                throw Xeption.forAdmin((String)"\u0412 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u0430\u044f \u0441\u0435\u0442\u043a\u0430 \u0434\u043b\u044f \u0430/\u043a {1}, \u043d\u043e \u043e\u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435", (Object[])new Object[]{((BaseAirGdsAccount)acCtr.getEntity()).getName(), ((BaseAirGdsAccount)acCtr.getEntity()).getSearchCityFilterAirline()});
            }
            if (GDSHelper.isRouteInAirlineGrid(fsp.getRoute(), aci)) continue;
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u043e\u0442\u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432\u0430\u043d \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u043e\u0439 \u0441\u0435\u0442\u043a\u043e\u0439 \u0430/\u043a {1}", (Object[])new Object[]{((BaseAirGdsAccount)acCtr.getEntity()).getName(), ((BaseAirGdsAccount)acCtr.getEntity()).getSearchCityFilterAirline()}));
            iterator.remove();
        }
        ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNTS, accounts);
    }
}

