/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FlightAndRuleProxies {
    private final Flight flight;
    private final Map<DictionaryReference<PassengerType>, RuleProxy<FlightPropertySet, GDSParametersActions>> ruleProxies;

    public FlightAndRuleProxies(Flight flight, Map<DictionaryReference<PassengerType>, RuleProxy<FlightPropertySet, GDSParametersActions>> ruleProxies) {
        this.flight = flight;
        this.ruleProxies = ruleProxies;
    }

    public Flight getFlight() {
        return this.flight;
    }

    public Map<DictionaryReference<PassengerType>, RuleProxy<FlightPropertySet, GDSParametersActions>> getRuleProxies() {
        return this.ruleProxies;
    }

    public <T> T getSingleValue(Function<RuleProxy<FlightPropertySet, GDSParametersActions>, T> function) {
        Set values = this.ruleProxies.values().stream().map(function).collect(Collectors.toSet());
        boolean hasStopPredicate = this.ruleProxies.values().stream().anyMatch(p -> p.getStopPredicate() != null);
        if (values.size() > 1 && !hasStopPredicate) {
            throw Xeption.forDeveloper((String)"value conflict across passenger types {0}", (Object[])new Object[]{values});
        }
        if (values.isEmpty() || values.size() > 1 && hasStopPredicate) {
            return null;
        }
        return values.iterator().next();
    }
}

