/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsBookabilityItem;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.gds.bookability.GdsBookability;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Map;

public class FlightBookabilityProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        Throwable exception = callback.getException();
        Map segments = ((SeatsNotConfirmedException)exception).getSegments();
        ArrayList<GdsBookabilityItem> result = new ArrayList<GdsBookabilityItem>();
        if (segments != null && segments.size() > 0) {
            for (Map.Entry entry : segments.entrySet()) {
                GdsBookabilityItem bi = GdsBookability.buildBookabilityItem(flight, (FlightSegment)entry.getKey(), (String)entry.getValue());
                result.add(bi);
            }
        } else {
            GdsBookabilityItem bi = GdsBookability.buildBookabilityItem(flight, exception.getMessage());
            result.add(bi);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_BOOKABILITY_ITEMS, result);
    }
}

