/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class FlightCarrierRoutingKeyProvider
extends BaseRoutingKeyProvider {
    private String codeSystem;

    public void configure(Map<String, String> parameters) {
        this.codeSystem = parameters.get("code-system");
    }

    public String getRoutingKey(MessageContext ctx) {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Airline carrier = (Airline)DictionaryCache.get().resolveReference(flight.getCarrier());
        if (carrier == null) {
            return null;
        }
        return (String)carrier.getCodeVariants().get(this.codeSystem);
    }
}

