/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.FlightAndRuleProxies;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.function.Function;

public class FlightRuleProxyBuilder
extends BaseProcessor {
    private static final Function<RuleProxy, Boolean> EXCLUDE_FROM_RESULT_PREDICATE = p -> ((GDSParametersActions)p.getActionSet()).isExcludeFromResult();

    public void process(MessageContext ctx) throws Exception {
        Boolean doNotExcludeFromResult = (Boolean)ctx.getObject((Enum)IBusGdsContextKeys.DO_NOT_EXCLUDE_FROM_RESULT);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isSaveRulesTraces = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        HashMap<DictionaryReference<PassengerType>, RuleProxy<FlightPropertySet, GDSParametersActions>> proxies = new HashMap<DictionaryReference<PassengerType>, RuleProxy<FlightPropertySet, GDSParametersActions>>();
        for (SeatPreferences sp : flight.getSeats()) {
            RuleProxy<FlightPropertySet, GDSParametersActions> proxy = this.createProxy(flight, (DictionaryReference<PassengerType>)sp.getPassengerType(), salesContext, isSaveRulesTraces);
            if (!Boolean.TRUE.equals(doNotExcludeFromResult)) {
                proxy.setStopPredicate(EXCLUDE_FROM_RESULT_PREDICATE);
            }
            proxies.put((DictionaryReference<PassengerType>)sp.getPassengerType(), proxy);
        }
        ArrayList ruleProxies = (ArrayList)ctx.getObject((Enum)IBusGdsContextKeys.RULE_PROXIES);
        if (ruleProxies == null) {
            ruleProxies = new ArrayList();
            ctx.putObject((Enum)IBusGdsContextKeys.RULE_PROXIES, ruleProxies);
        }
        ruleProxies.addAll(proxies.values());
        FlightAndRuleProxies farp = new FlightAndRuleProxies(flight, proxies);
        ArrayList<FlightAndRuleProxies> farps = (ArrayList<FlightAndRuleProxies>)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_AND_RULE_PROXIES);
        if (farps == null) {
            farps = new ArrayList<FlightAndRuleProxies>();
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_AND_RULE_PROXIES, farps);
        }
        farps.add(farp);
    }

    protected RuleProxy<FlightPropertySet, GDSParametersActions> createProxy(Flight flight, DictionaryReference<PassengerType> passengerType, SalesContext salesContext, boolean proxyTracerEnabled) {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(Targets.GDS_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)FlightPropertySet.create(flight, passengerType, PaymentType.INVOICE, null, proxy, salesContext));
        proxy.setActionSet((Object)new GDSParametersActions());
        return proxy;
    }
}

