/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.FlightAndRuleProxies;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FlightSalesChainBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        boolean ownSales;
        Validator val;
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        FlightAndRuleProxies farp = (FlightAndRuleProxies)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_AND_RULE_PROXY);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        EntityReference agency = (EntityReference)ctx.getObject((Enum)IBusGdsContextKeys.AGENCY);
        Flight flight = farp.getFlight();
        if (!flights.contains(flight)) {
            return;
        }
        SalesChain salesChain = new SalesChain();
        ArrayList<Contractor> contractors = new ArrayList<Contractor>();
        EntityReference blankOwner = flight.getBlankOwner();
        NestedEntityReference pccRef = farp.getSingleValue(rp -> ((GDSParametersActions)rp.getActionSet()).getTicketingPCCRef());
        if (pccRef != null) {
            MiscUtil.Pair salesPointAndPccPair = EntityStorageHelper.resolveDetailed((NestedEntityReference)pccRef, (EntityStorageContext)EntityStorageHelper.createContext());
            val = GDSHelper.findValidator((EntityContainer<SalesPoint>)((EntityContainer)salesPointAndPccPair.getFirst()), (Pcc)salesPointAndPccPair.getSecond(), (EntityReference<Organization>)blankOwner);
        } else {
            String ticketingPCC = farp.getSingleValue(rp -> ((GDSParametersActions)rp.getActionSet()).getTicketingPCC());
            val = GDSHelper.findValidatorByPccAndBlankOwner((EntityReference<SalesPoint>)sc.getSalesPoint(), ticketingPCC, (EntityReference<Organization>)blankOwner);
        }
        if (val == null && blankOwner != null) {
            val = GDSHelper.findValidatorByBlankOwner((EntityReference<SalesPoint>)sc.getSalesPoint(), (EntityReference<Organization>)blankOwner);
        }
        if (val != null && val.getSupplier() != null) {
            contractors.add(GeneralProductHelper.getContractor((List)salesChain.getContractors(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER, (EntityReference)val.getSupplier()));
        } else if (blankOwner != null) {
            contractors.add(GeneralProductHelper.getContractor((List)salesChain.getContractors(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER, (EntityReference)blankOwner));
        }
        if (agency == null) {
            agency = sc.getAgency();
        }
        contractors.add(GeneralProductHelper.getContractor((List)salesChain.getContractors(), (PredefinedContractorType)PredefinedContractorType.AGENCY, (EntityReference)agency));
        EntityReference subagency = sc.getSubagency();
        boolean bl = ownSales = subagency == null || subagency.equals((Object)agency);
        if (!ownSales) {
            contractors.add(GeneralProductHelper.getContractor((List)salesChain.getContractors(), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, (EntityReference)subagency));
        }
        if (sc.getTechnicalProvider() != null) {
            contractors.add(GeneralProductHelper.getContractor((List)salesChain.getContractors(), (PredefinedContractorType)PredefinedContractorType.TECHNICAL_PROVIDER, (EntityReference)sc.getTechnicalProvider()));
        }
        contractors.add(GeneralProductHelper.getContractor((List)salesChain.getContractors(), (PredefinedContractorType)PredefinedContractorType.CLIENT, (EntityReference)sc.getClient()));
        if (sc.getTechnicalProvider() != null) {
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription((PredefinedSalesChainType)(ownSales ? PredefinedSalesChainType.OWN_TECHNICAL_PROVIDER : PredefinedSalesChainType.SUBAGENT_TECHNICAL_PROVIDER), (EntityReference)salesChain.getDescription()));
        } else {
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription((PredefinedSalesChainType)(ownSales ? PredefinedSalesChainType.OWN : PredefinedSalesChainType.SUBAGENT), (EntityReference)salesChain.getDescription()));
        }
        salesChain.getContractors().clear();
        salesChain.getContractors().addAll(contractors);
        flight.setSalesChain(salesChain);
    }
}

