/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.Validatable;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeoLocationHelper;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.common.model.validation.ValidationHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class FlightSearchParametersValidator
extends BaseProcessor {
    private static final Integer MAX_PASSENGERS_TYPE_COUNT = 4;

    public void process(MessageContext ctx) {
        ClassOfService classOfService;
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        List route = fsp.getRoute();
        if (route.size() == 0 || route.size() > 10) {
            fsp.getValidationContext().getRouteValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteInvalidSize());
        }
        if (fsp.getSeats().isEmpty()) {
            fsp.getValidationContext().getSeatsValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        this.validateRouteSegments(route);
        this.validatePassengerTypesCount(fsp);
        int majors = 0;
        int infants = 0;
        int totalSeats = 0;
        for (SeatPreferences sp : fsp.getSeats()) {
            DictionaryReference passengerType = sp.getPassengerType();
            if (passengerType == null) {
                sp.getValidationContext().getPassengerTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
                continue;
            }
            int count = sp.getCount();
            if (count <= 0) {
                sp.getValidationContext().getCountValidationMessages().add(GdsValidationMessages.getSeatsCountTooSmall());
                continue;
            }
            if (DictHelper.isAdultPassengerTypeCategory((DictionaryReference)passengerType)) {
                majors += count;
                totalSeats += count;
                continue;
            }
            if (DictHelper.isChildPassengerTypeCategory((DictionaryReference)passengerType)) {
                totalSeats += count;
                continue;
            }
            if (DictHelper.isInfantPassengerTypeCategory((DictionaryReference)passengerType)) {
                if (DictHelper.isInfantPassengerType((DictionaryReference)passengerType)) {
                    infants += count;
                    continue;
                }
                totalSeats += count;
                continue;
            }
            sp.getValidationContext().getPassengerTypeValidationMessages().add(GdsValidationMessages.getSeatsPassengerTypeNotSupported());
        }
        if (majors == 0 || infants > majors) {
            fsp.getValidationContext().getSeatsValidationMessages().add(GdsValidationMessages.getSeatsNotEnoughMajorPassengers());
        }
        if (totalSeats > 9) {
            fsp.getValidationContext().getSeatsValidationMessages().add(GdsValidationMessages.getSeatsTooManyPassengers());
        }
        if ((classOfService = fsp.getServiceClass()) == null) {
            fsp.getValidationContext().getServiceClassValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        List preferredAirlines = fsp.getPreferredAirlines();
        for (int i = 0; i < preferredAirlines.size(); ++i) {
            DictionaryReference airlineRef = (DictionaryReference)preferredAirlines.get(i);
            Airline airline = (Airline)DictionaryCache.get().resolveReference(airlineRef);
            if (airline != null) continue;
            fsp.getValidationContext().getPreferredAirlinesListValidationMessages().put(i, Collections.singleton(StandardValidationMessages.getInvalidDictionaryReference()));
        }
        if (!ValidationHelper.isValid((Validatable)fsp)) {
            throw new ValidationException();
        }
    }

    private void validatePassengerTypesCount(FlightSearchParameters fsp) {
        long passengersTypesCount = fsp.getSeats().stream().map(SeatPreferences::getPassengerType).filter(Objects::nonNull).count();
        if (passengersTypesCount > (long)MAX_PASSENGERS_TYPE_COUNT.intValue()) {
            fsp.getValidationContext().getSeatsValidationMessages().add(GdsValidationMessages.getPassengerCategoriesIncompatible());
        }
    }

    protected boolean validate(DictionaryReference<GeoLocation> locationRef, Collection<ValidationMessage> vms) {
        boolean result = true;
        if (locationRef == null) {
            vms.add(StandardValidationMessages.getMissingRequiredValue());
            result = false;
        } else {
            GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(locationRef);
            if (location == null || !Arrays.asList(LocationType.AIRPORT, LocationType.CITY).contains(location.getType())) {
                vms.add(StandardValidationMessages.getInvalidDictionaryReference());
                result = false;
            }
        }
        return result;
    }

    protected void validateRouteSegments(List<RouteSegment> route) {
        LocalDate now = LocalDate.now();
        RouteSegment lastRs = null;
        for (RouteSegment rs : route) {
            Date date;
            boolean locationBeginValid = this.validate((DictionaryReference<GeoLocation>)rs.getLocationBegin(), rs.getValidationContext().getLocationBeginValidationMessages());
            boolean locationEndValid = this.validate((DictionaryReference<GeoLocation>)rs.getLocationEnd(), rs.getValidationContext().getLocationEndValidationMessages());
            if (locationBeginValid && locationEndValid) {
                GeoLocation cityBegin = GeoLocationHelper.getCity((DictionaryReference)rs.getLocationBegin());
                GeoLocation cityEnd = GeoLocationHelper.getCity((DictionaryReference)rs.getLocationEnd());
                if (cityBegin.getCode().equals(cityEnd.getCode())) {
                    rs.getValidationContext().getLocationBeginValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
                    rs.getValidationContext().getLocationEndValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteLocationsEqualOrInSameCity());
                }
            }
            if ((date = rs.getDate()) == null) {
                rs.getValidationContext().getDateValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
            } else if (date.compareTo(now.toDate()) < 0) {
                rs.getValidationContext().getDateValidationMessages().add(GdsValidationMessages.getDateTooEarly());
            } else {
                LocalDate dt = new LocalDate(date.getTime());
                if (dt.getDayOfYear() < now.getDayOfYear() && dt.getYear() <= now.getYear()) {
                    rs.getValidationContext().getDateValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteDateTooEarly());
                } else if (Days.daysBetween((ReadablePartial)now, (ReadablePartial)dt).getDays() > 362) {
                    rs.getValidationContext().getDateValidationMessages().add(GdsValidationMessages.getFlightSearchParametersRouteDateTooLate());
                }
                if (lastRs != null && lastRs.getDate() != null && dt.isBefore((ReadablePartial)new LocalDate((Object)lastRs.getDate()))) {
                    lastRs.getValidationContext().getDateValidationMessages().add(GdsValidationMessages.getWrongDate());
                    rs.getValidationContext().getDateValidationMessages().add(GdsValidationMessages.getWrongDate());
                }
            }
            if (rs.getDepartureTimeBegin() != null && rs.getDepartureTimeEnd() != null) {
                LocalTime timeBegin = LocalTime.fromMillisOfDay((long)((long)rs.getDepartureTimeBegin().intValue() * 60000L));
                LocalTime timeEnd = LocalTime.fromMillisOfDay((long)((long)rs.getDepartureTimeEnd().intValue() * 60000L));
                if (!timeEnd.isAfter((ReadablePartial)timeBegin)) {
                    rs.getValidationContext().getDepartureTimeBeginValidationMessages().add(GdsValidationMessages.getWrongDate());
                    rs.getValidationContext().getDepartureTimeEndValidationMessages().add(GdsValidationMessages.getWrongDate());
                }
            }
            lastRs = rs;
        }
    }
}

