/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleLogTracer;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightSubsidizedContractActionSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightSubsidizedContractRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(FlightSubsidizedContractRulesHelper.class);

    public static void applySubsidizedContracts(Flight flight, List<EntityContainer<Contract>> contracts, FlightPropertySet propertySet, DictionaryReference<PassengerType> pt, Date date, RuleLogTracer tracer, Collection<ValidationMessage> messages) {
        log.debug("Subsidized rules apllying begin");
        try {
            String logStr;
            ArrayList<RuleProxy> proxyList = new ArrayList<RuleProxy>();
            RuleProxy proxy = new RuleProxy();
            proxy.setProxyType(Targets.AVIA_SUBSIDIZED.getId());
            proxy.setProxyDate(new Date());
            proxy.setPropertySet((Object)propertySet);
            proxy.setActionSet((Object)new FlightSubsidizedContractActionSet(proxy, propertySet, pt));
            proxyList.add(proxy);
            for (EntityContainer<Contract> ctr : contracts) {
                log.debug("applying contract " + ctr.toReference());
                List rules = ProfileHelper.getRuleContainers(ctr, (Date)(date != null ? date : new Date()));
                for (EntityContainer rulesContainer : rules) {
                    log.debug("applying container " + rulesContainer.toReference());
                    RuleSet ruleSet = ProfileHelper.getRuleSet((EntityContainer)rulesContainer);
                    if (ruleSet == null) continue;
                    HashSet appliedRulesBefore = new HashSet(proxy.getAppliedRules());
                    RuleEngine.applyRules(proxyList, (RuleSet)ruleSet);
                    tracer.traceLogic(String.format("container applied: contract = %s", rulesContainer.toReference()));
                    HashSet appliedRulesLocal = new HashSet(proxy.getAppliedRules());
                    appliedRulesLocal.removeAll(appliedRulesBefore);
                    if (appliedRulesLocal.isEmpty()) continue;
                    tracer.traceLogic(String.format("some rules applied: contract = %s, container = %s", ctr.toReference(), rulesContainer.toReference()));
                    for (String ruleUid : proxy.getAppliedRules()) {
                        RuleSettings rule = (RuleSettings)CollectionUtil.find((Iterable)ruleSet.getRules(), (String)ruleUid);
                        if (rule == null) {
                            log.error(String.format("unable to find rule with uid %s in contract %s", ruleUid, ctr));
                            tracer.traceWarn(String.format("unable to find rule: contract=%s, uid=%s", ctr.toReference(), ruleUid), null);
                            continue;
                        }
                        String logStr2 = String.format("rule \u2116 %s was applied", Integer.toString(ruleSet.getRules().indexOf(rule) + 1));
                        tracer.traceLogic(logStr2);
                        log.debug(logStr2);
                    }
                }
                tracer.traceLogic(String.format("contract applied: contract = %s", ctr.toReference()));
            }
            FlightSubsidizedContractActionSet actionSet = (FlightSubsidizedContractActionSet)((Object)proxy.getActionSet());
            if (flight.getTripartiteContractDetails() == null) {
                flight.setTripartiteContractDetails(new TripartiteContractDetails());
            }
            if (!actionSet.getTourCodes().isEmpty()) {
                flight.setTourCode((String)actionSet.getTourCodes().get(0));
                logStr = String.format("tour code %s was set", actionSet.getTourCodes().get(0));
                tracer.traceLogic(logStr);
                log.debug(logStr);
            } else if (actionSet.areTourCodesOverridden()) {
                flight.setTourCode(null);
                logStr = String.format("tour code %s was set", "null");
                tracer.traceLogic(logStr);
                log.debug(logStr);
            }
            if (!flight.isIgnoreContractsForSubsidizedTariffFlag()) {
                if (actionSet.isSubsidized()) {
                    flight.setSubsidizedTariff(true);
                    logStr = String.format("subsidized attribute= %s was set", "True");
                    tracer.traceLogic(logStr);
                    log.debug(logStr);
                } else {
                    flight.setSubsidizedTariff(false);
                    logStr = String.format("subsidized attribute= %s was set", "False");
                    tracer.traceLogic(logStr);
                    log.debug(logStr);
                }
            } else {
                logStr = "subsidized tariff flag unchanged, because it is set externally";
                tracer.traceLogic(logStr);
                log.debug(logStr);
            }
            if (actionSet.getIssuedUnder3d() != null) {
                flight.getTripartiteContractDetails().setIssuedUnder3d(actionSet.getIssuedUnder3d().booleanValue());
            }
            flight.getTripartiteContractDetails().setTourcodeType(actionSet.getCalculationIndicator());
            flight.getTripartiteContractDetails().setPublicFareDiscount(actionSet.getPublicFareDiscount());
            if (actionSet.getPublicFareDiscount() != null && flight.isNeedToApplyPublicFareDiscount()) {
                FlightSubsidizedContractRulesHelper.updateFaresWithDiscount(flight, actionSet.getPublicFareDiscount(), null, tracer);
            }
            flight.getTripartiteContractDetails().getSsrs().addAll(actionSet.getSsrs());
            if (tracer != null) {
                tracer.traceLogic("added ssrs " + actionSet.getSsrs());
            }
            flight.getTripartiteContractDetails().setTripartiteDiscountDocument(actionSet.getTripartiteDiscountDocument());
            if (tracer != null) {
                tracer.traceLogic("set discount document " + actionSet.getTripartiteDiscountDocument());
            }
            flight.getTripartiteContractDetails().setSubstitutePassengerType(actionSet.getSubstitutePassengerType());
            flight.getTripartiteContractDetails().getSubstituteBrandIds().clear();
            flight.getTripartiteContractDetails().getSubstituteBrandIds().putAll(actionSet.getSubstituteBrandIds());
            flight.getTripartiteContractDetails().setContractCode(actionSet.getContractCode());
            flight.getTripartiteContractDetails().setTripartiteContractRemark(actionSet.getTripartiteContractRemark());
        }
        catch (Throwable e) {
            log.error("failed applying subsidized contracts for flight", e);
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_SYSTEM_ERROR, (Throwable)e, (Object[])new Object[0]));
        }
    }

    public static void updateFaresWithDiscount(Flight flight, TripartitePublicFareDiscount publicFareDiscount, GdsTracingItemBuilder<Flight> builder, RuleLogTracer tracer) {
        HashMap<DictionaryReference, ArrayList<FlightFare>> faresMap = new HashMap<DictionaryReference, ArrayList<FlightFare>>();
        for (FlightFare flightFare : flight.getFares()) {
            ArrayList<FlightFare> faresList = (ArrayList<FlightFare>)faresMap.get(flightFare.getPassengerType());
            if (faresList == null) {
                faresList = new ArrayList<FlightFare>();
                faresMap.put(flightFare.getPassengerType(), faresList);
            }
            faresList.add(flightFare);
        }
        for (Map.Entry entry : faresMap.entrySet()) {
            BigDecimal fareDiscountValue;
            String curr = null;
            BigDecimal baseAmount = BigDecimal.ZERO;
            BigDecimal equivAmount = BigDecimal.ZERO;
            boolean hasDifferentCurrencies = false;
            boolean hasNullBaseAmount = false;
            for (FlightFare fare : (List)entry.getValue()) {
                if (fare.getBaseAmount() == null) {
                    hasNullBaseAmount = true;
                    continue;
                }
                if (curr == null) {
                    curr = fare.getBaseAmount().getCurrency();
                } else if (!fare.getBaseAmount().getCurrency().equals(curr)) {
                    hasDifferentCurrencies = true;
                }
                baseAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{baseAmount, fare.getBaseAmount().getValue()});
                equivAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{equivAmount, fare.getEquivalentAmount()});
            }
            FlightFare discountFare = new FlightFare();
            discountFare.setCode(((FlightFare)((List)entry.getValue()).get(0)).getCode());
            discountFare.setPassengerType((DictionaryReference)entry.getKey());
            flight.getFares().add(discountFare);
            if (!hasNullBaseAmount && !hasDifferentCurrencies && curr != null) {
                fareDiscountValue = publicFareDiscount.isRate() ? FlightSubsidizedContractRulesHelper.calcFareDiscountValue(publicFareDiscount.getValue(), baseAmount, curr) : publicFareDiscount.getValue();
                Money baseFare = new Money();
                baseFare.setCurrency(curr);
                baseFare.setValue(fareDiscountValue.negate());
                discountFare.setBaseAmount(baseFare);
            }
            fareDiscountValue = publicFareDiscount.isRate() ? FlightSubsidizedContractRulesHelper.calcFareDiscountValue(publicFareDiscount.getValue(), equivAmount, FlightSubsidizedContractRulesHelper.getVendorCurrency(flight)) : publicFareDiscount.getValue();
            discountFare.setEquivalentAmount(fareDiscountValue.negate());
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("equivalent fare %s was corrected with discount %s", equivAmount, fareDiscountValue));
            }
            if (tracer == null) continue;
            tracer.traceLogic(String.format("equivalent fare %s was corrected with discount %s", equivAmount, fareDiscountValue));
        }
    }

    private static String getVendorCurrency(Flight flight) {
        GdsContractRelationData contractRelation = FlightHelper.getContractRelations((Flight)flight, (ContractType)ContractType.VENDOR).values().stream().findFirst().orElse(null);
        if (Objects.isNull(contractRelation) || Objects.isNull(contractRelation.getGeneralData()) || Objects.isNull(contractRelation.getGeneralData().getCurrency())) {
            return null;
        }
        return contractRelation.getGeneralData().getCurrency().getCode();
    }

    private static BigDecimal calcFareDiscountValue(BigDecimal rate, BigDecimal baseAmount, String currencyCode) {
        if ("RUB".equals(currencyCode)) {
            BigDecimal result = baseAmount.multiply(rate).divide(new BigDecimal("100"));
            int value = result.intValue();
            return BigDecimal.valueOf(value / 5 * 5);
        }
        return baseAmount.multiply(rate).divide(new BigDecimal("100")).setScale(0, RoundingMode.UP);
    }
}

