/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.TripartitePublicFareDiscount;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCalculationIndicatorType;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.validation.StandartValidationMessageType;
import com.gridnine.xtrip.common.model.validation.ValidationMessageHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.FlightSubsidizedContractRulesHelper;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightCommissionActionSet;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightTripartiteContractActionSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightTripartiteContractRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(FlightTripartiteContractRulesHelper.class);

    private static boolean isAppropriateDate(TripartiteContractCustomerInfo info, Date dayStart, Date dayEnd) {
        if (info.getStartDate() != null && info.getStartDate().after(dayEnd)) {
            return false;
        }
        return info.getEndDate() == null || !info.getEndDate().before(dayStart);
    }

    private static RuleSet applyRules(EntityContainer<TripartiteContract> contract, List<RuleProxy<?, ?>> proxyList) throws Exception {
        RuleSet result = ((TripartiteContract)contract.getEntity()).getRuleSet();
        long start = System.currentTimeMillis();
        RuleEngine.applyRules(proxyList, (RuleSet)result);
        MiscUtil.logTiming((long)start, (String)String.format("contract %s applied to the flight", contract.toReference()));
        return result;
    }

    public static AirTripartiteContractRulesResult applyTripartiteContracts(Flight flight, SalesContext ctx, RuleProxy<FlightPropertySet, FlightCommissionActionSet> proxy, DictionaryReference<PassengerType> pt, Collection<ValidationMessage> messages, GdsTracingItemBuilder<Flight> builder) {
        TripartitePublicFareDiscount publicFareDiscount;
        Boolean issuedUnder3d;
        if (flight.getMtdSettings() != null) {
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "skipped tripartite contracts for mtd flight");
            }
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        List<EntityContainer<TripartiteContract>> contracts = null;
        try {
            contracts = FlightTripartiteContractRulesHelper.collectContracts(flight, ctx, proxy, messages, builder);
        }
        catch (Throwable e2) {
            log.error("failed collecting tripartite contracts for flight", e2);
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.ERROR, String.format("failed collecting contracts: %s", e2.toString()));
            }
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_SYSTEM_ERROR, (Throwable)e2, (Object[])new Object[0]));
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        if (contracts.isEmpty()) {
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "no tripartite contract found");
            }
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        EntityContainer<TripartiteContract> contract = contracts.get(0);
        if (flight.getTripartiteContractDetails() == null) {
            flight.setTripartiteContractDetails(new TripartiteContractDetails());
        }
        flight.getTripartiteContractDetails().setTripartiteContract(contract.toReference());
        proxy.setActionSet((Object)new FlightTripartiteContractActionSet(proxy, (FlightPropertySet)((Object)proxy.getPropertySet()), pt));
        try {
            for (EntityContainer<TripartiteContract> ctr : contracts) {
                log.debug("applying contract " + ctr.toReference());
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("applying tripartite contract %s", ((TripartiteContract)ctr.getEntity()).toString()));
                }
                ArrayList proxyList = new ArrayList();
                proxyList.add(proxy);
                HashSet appliedRulesBefore = new HashSet(proxy.getAppliedRules());
                RuleSet rules = FlightTripartiteContractRulesHelper.applyRules(ctr, proxyList);
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("contract applied: contract = %s", ctr.toReference()));
                }
                HashSet appliedRulesLocal = new HashSet(proxy.getAppliedRules());
                appliedRulesLocal.removeAll(appliedRulesBefore);
                if (appliedRulesLocal.isEmpty()) continue;
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("some rules applied: contract = %s", ctr.toReference()));
                }
                for (String ruleUid : proxy.getAppliedRules()) {
                    RuleSettings rule = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                    if (rule == null) {
                        log.error(String.format("unable to find rule with uid %s in contract %s", ruleUid, ctr));
                        if (builder == null) continue;
                        builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, String.format("unable to find rule with uid %s in contract %s", ruleUid, ctr));
                        continue;
                    }
                    String logStr = String.format("rule \u2116 %s was applied", Integer.toString(rules.getRules().indexOf(rule) + 1));
                    log.debug(logStr);
                    if (builder == null) continue;
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, logStr);
                }
            }
        }
        catch (Throwable e3) {
            log.error("failed applying tripartite contracts for flight", e3);
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.ERROR, "failed applying tripartite contracts for flight " + e3.toString());
            }
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_SYSTEM_ERROR, (Throwable)e3, (Object[])new Object[0]));
            return new AirTripartiteContractRulesResult(Collections.emptyMap(), false);
        }
        FlightTripartiteContractActionSet actionSet = (FlightTripartiteContractActionSet)((Object)proxy.getActionSet());
        if (!actionSet.getTourCodes().isEmpty()) {
            String tourCode = (String)actionSet.getTourCodes().get(0);
            flight.setTourCode(tourCode);
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "tour code is set to " + tourCode);
            }
        }
        if ((issuedUnder3d = actionSet.getIssuedUnder3d()) != null) {
            flight.getTripartiteContractDetails().setIssuedUnder3d(issuedUnder3d.booleanValue());
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "issued under 3d was set  to " + issuedUnder3d);
            }
        }
        TripartiteContractCalculationIndicatorType calculationIndicator = actionSet.getCalculationIndicator();
        flight.getTripartiteContractDetails().setTourcodeType(calculationIndicator);
        if (builder != null) {
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "tour code type is set to " + calculationIndicator);
        }
        if ((publicFareDiscount = actionSet.getPublicFareDiscount()) != null) {
            flight.getTripartiteContractDetails().setPublicFareDiscount(publicFareDiscount);
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("public fare discount is set to: discount =%s %s, designator = %s ", publicFareDiscount.getValue(), publicFareDiscount.getCurrency(), publicFareDiscount.getTicketDesignator()));
            }
            if (flight.isNeedToApplyPublicFareDiscount()) {
                FlightSubsidizedContractRulesHelper.updateFaresWithDiscount(flight, publicFareDiscount, builder, null);
            }
        } else {
            flight.getTripartiteContractDetails().setPublicFareDiscount(null);
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "public fare discount is set to null");
            }
        }
        flight.getTripartiteContractDetails().getSsrs().addAll(actionSet.getSsrs());
        if (builder != null) {
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "added ssrs " + actionSet.getSsrs());
        }
        flight.getTripartiteContractDetails().setTripartiteDiscountDocument(actionSet.getTripartiteDiscountDocument());
        if (builder != null) {
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "set discount document " + actionSet.getTripartiteDiscountDocument());
        }
        flight.getTripartiteContractDetails().setSubstitutePassengerType(actionSet.getSubstitutePassengerType());
        if (builder != null) {
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "substitute passenger type was set  to " + actionSet.getSubstitutePassengerType());
        }
        flight.getTripartiteContractDetails().getSubstituteBrandIds().clear();
        flight.getTripartiteContractDetails().getSubstituteBrandIds().putAll(actionSet.getSubstituteBrandIds());
        if (builder != null) {
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "substitute brand ids was set  to " + actionSet.getSubstituteBrandIds().entrySet().stream().map(e -> String.join((CharSequence)"->", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.joining(", ")));
        }
        flight.getTripartiteContractDetails().setUsePersonDiscountCard(actionSet.getUsePersonDiscountCard());
        if (builder != null) {
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "use person discount card was set to " + actionSet.getUsePersonDiscountCard());
        }
        flight.getTripartiteContractDetails().setContractCode(actionSet.getContractCode());
        if (builder != null) {
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "contract code was set  to " + actionSet.getContractCode());
        }
        flight.getTripartiteContractDetails().setTripartiteContractRemark(actionSet.getTripartiteContractRemark());
        if (builder != null) {
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "3D remark was set  to " + actionSet.getTripartiteContractRemark());
        }
        if (!actionSet.getAccountingCodes().isEmpty()) {
            if (actionSet.getAccountingCodes().size() > 1) {
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, String.format("calculating %s accounting code, skipping update", Integer.toBinaryString(actionSet.getAccountingCodes().size())));
                }
            } else if (flight.isAccountCodeApplied()) {
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "flight already has accounting code, skipping update");
                }
            } else {
                flight.setAccountCode(actionSet.getAccountingCodes().get(0));
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "accounting code was set to " + flight.getAccountCode());
                }
            }
        }
        if (!actionSet.getCorporateIds().isEmpty()) {
            if (actionSet.getCorporateIds().size() > 1) {
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, String.format("calculating %s corporate id, skipping update", Integer.toBinaryString(actionSet.getCorporateIds().size())));
                }
            } else if (flight.isCorporateIdApplied()) {
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "flight already has corporate id, skipping update");
                }
            } else {
                flight.setCorporateId(actionSet.getCorporateIds().get(0));
                if (builder != null) {
                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "corporate id was set to " + flight.getCorporateId());
                }
            }
        }
        HashMap<ContractType, Map<String, RuleResultValue>> result = new HashMap<ContractType, Map<String, RuleResultValue>>();
        for (Map.Entry entry : ((FlightCommissionActionSet)((Object)proxy.getActionSet())).getResults().entrySet()) {
            RuleResultValue value = (RuleResultValue)entry.getValue();
            ContractType contractType = value.getTarget() != null && FeeProperties.class.equals((Object)value.getTarget().getType()) ? ContractType.CLIENT : ContractType.VENDOR;
            HashMap values = (HashMap)result.get(contractType);
            if (values == null) {
                values = new HashMap();
                result.put(contractType, values);
            }
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("tripartite commission added: category = %s, type = %s, value = %s %s", entry.getKey(), ((RuleResultValue)entry.getValue()).getTarget(), Double.toString(((RuleResultValue)entry.getValue()).getValue()), ((RuleResultValue)entry.getValue()).getCurrencyCode()));
            }
            values.put(entry.getKey(), entry.getValue());
        }
        return new AirTripartiteContractRulesResult(result, true);
    }

    private static List<EntityContainer<TripartiteContract>> collectContracts(Flight flight, SalesContext ctx, RuleProxy<FlightPropertySet, FlightCommissionActionSet> proxy, Collection<ValidationMessage> messages, GdsTracingItemBuilder<Flight> builder) {
        ArrayList<EntityContainer<TripartiteContract>> result = new ArrayList<EntityContainer<TripartiteContract>>();
        if (ctx.getAgency() == null) {
            String msg = "no agency defined for flight, unable to apply tripartite contract";
            log.warn("no agency defined for flight, unable to apply tripartite contract");
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, "no agency defined for flight, unable to apply tripartite contract");
            }
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_AGENCY_NOT_DEFINED));
            return result;
        }
        if (ctx.getClient() == null) {
            String msg = "no corporate client defined for flight, unable to apply tripartite contract";
            log.warn("no corporate client defined for flight, unable to apply tripartite contract");
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, "no corporate client defined for flight, unable to apply tripartite contract");
            }
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_CLIENT_NOT_DEFINED));
            return result;
        }
        EntityReference customer = ctx.getClient();
        if (flight.getCarrier() == null) {
            String msg = "no corporate carrier for flight, unable to apply tripartite contract";
            if (builder != null) {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, "no corporate carrier for flight, unable to apply tripartite contract");
            }
            proxy.getTracer().traceWarn("no corporate carrier for flight, unable to apply tripartite contract", null);
            messages.add(ValidationMessageHelper.createValidationMessage((ValidationMessageType)StandartValidationMessageType.ATCRH_CARRIER_NOT_DEFINED));
            return result;
        }
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        SearchQuery query = new SearchQuery();
        if (allAgenciesProfile == null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.agency.name(), (Object)ctx.getAgency()));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)TripartiteContractIndex.Property.agency.name(), (Object)ctx.getAgency()), SearchCriterion.eq((String)TripartiteContractIndex.Property.agency.name(), (Object)allAgenciesProfile)}));
        }
        if (allClientsProfile == null) {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)customer.getUid()));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)customer.getUid()), SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)allClientsProfile.getUid())}));
        }
        Airline carrier = (Airline)DictionaryCache.get().resolveReference(flight.getCarrier());
        if (carrier != null && carrier.getAlliance() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)TripartiteContractIndex.Property.vendorAirlines.name(), (Object)flight.getCarrier().getCode()), SearchCriterion.contains((String)TripartiteContractIndex.Property.vendorAlliances.name(), (Object)carrier.getAlliance().getCode())}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.vendorAirlines.name(), (Object)flight.getCarrier().getCode()));
        }
        Date date = new Date();
        Date dayEnd = null;
        Date dayStart = null;
        if (date != null) {
            dayEnd = MiscUtil.setDayEndTime((Date)date);
            dayStart = MiscUtil.clearTime((Date)date);
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)TripartiteContractIndex.Property.firstStartDate.name(), null), SearchCriterion.le((String)TripartiteContractIndex.Property.firstStartDate.name(), (Object)dayEnd)}));
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)TripartiteContractIndex.Property.lastEndDate.name(), null), SearchCriterion.ge((String)TripartiteContractIndex.Property.lastEndDate.name(), (Object)dayStart)}));
        }
        List indexes = EntityStorage.get().search(TripartiteContractIndex.class, query, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS).getData();
        block0: for (TripartiteContractIndex index : indexes) {
            EntityContainer ctr = EntityStorage.get().resolve(index.getSource());
            if (date != null) {
                TripartiteContractCustomerInfo info2;
                for (TripartiteContractCustomerInfo info2 : ((TripartiteContract)ctr.getEntity()).getCustomers()) {
                    if (!customer.equals((Object)info2.getCustomer())) continue;
                    if (!FlightTripartiteContractRulesHelper.isAppropriateDate(info2, dayStart, dayEnd)) continue block0;
                    result.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(index.getSource()));
                    continue block0;
                }
                Iterator iterator = ((TripartiteContract)ctr.getEntity()).getCustomers().iterator();
                if (!iterator.hasNext() || !FlightTripartiteContractRulesHelper.isAppropriateDate(info2 = (TripartiteContractCustomerInfo)iterator.next(), dayStart, dayEnd)) continue;
                result.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(index.getSource()));
                continue;
            }
            result.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(index.getSource()));
        }
        Collections.sort(result, new Comparator<EntityContainer<TripartiteContract>>(){

            @Override
            public int compare(EntityContainer<TripartiteContract> o1, EntityContainer<TripartiteContract> o2) {
                return MiscUtil.compare((Date)this.findIssueDate(o1), (Date)this.findIssueDate(o2), (boolean)false);
            }

            private Date findIssueDate(EntityContainer<TripartiteContract> o1) {
                for (TripartiteContractCustomerInfo info : ((TripartiteContract)o1.getEntity()).getCustomers()) {
                    if (info.getIssueDate() == null) continue;
                    return info.getIssueDate();
                }
                return null;
            }
        });
        return result;
    }

    private FlightTripartiteContractRulesHelper() {
    }

    public static class AirTripartiteContractRulesResult {
        public final Map<ContractType, Map<String, RuleResultValue>> commissions;
        public final boolean hasTripartiteContracts;

        AirTripartiteContractRulesResult(Map<ContractType, Map<String, RuleResultValue>> commissionsValue, boolean hasTripartiteContractsValue) {
            this.commissions = commissionsValue;
            this.hasTripartiteContracts = hasTripartiteContractsValue;
        }
    }
}

