/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightsAggregator
extends BaseProcessor {
    private static final Logger flightSearchStatsLogger = LoggerFactory.getLogger((String)"flightSearchStatsLogger");

    public void process(MessageContext ctx) throws Exception {
        ArrayList result = new ArrayList();
        Map mcres = (Map)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_MULTICALL_RESULT);
        if (mcres == null) {
            ctx.addMessage(MessageHelper.createWarningMessage((String)"\u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u043c\u044b\u0445 \u0441\u0438\u0441\u0442\u0435\u043c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0443\u0441\u0442, \u043f\u043e\u0438\u0441\u043a \u043d\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d", (Object[])new Object[0]));
        } else {
            String user = this.getUser(ctx);
            long total = 0L;
            long currentTime = System.currentTimeMillis();
            int threads = mcres.values().size();
            String tid = UUIDUtil.toString((UUID)UUID.randomUUID());
            for (MessageContext subctx : mcres.values()) {
                MiscUtil.Pair statistics;
                Collection flights = (Collection)subctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
                if (flights != null) {
                    result.addAll(flights);
                }
                if (threads <= 1 || (statistics = (MiscUtil.Pair)subctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_STATISTICS)) == null) continue;
                long time = currentTime - (Long)statistics.getSecond();
                Integer flightsCount = (Integer)statistics.getFirst();
                total += time * (long)flightsCount.intValue();
                flightSearchStatsLogger.debug("kept {} flights from {} for {} ms (user {}) (tid {})", new Object[]{flightsCount, subctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT), time, user, tid});
            }
            if (threads > 1) {
                flightSearchStatsLogger.debug("total metric value {} (user {}}) (tid {})", new Object[]{total, user, tid});
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, result);
    }

    private String getUser(MessageContext ctx) {
        SalesContext salesContext = (SalesContext)ctx.getObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        return Optional.ofNullable(salesContext).map(context -> EntityStorage.get().resolve(context.getAgent())).map(ctr -> ((Person)ctr.getEntity()).getLoginName()).orElse("");
    }
}

