/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.CollectedContractData;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsCommission;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.VendorCommissionDebugItem;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.MultiException;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.ContractRelationGeneralData;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.CurrencyInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ContractRelationHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.BaseRulesContainer;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.ContractorDescription;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.RuleResultValue;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.FlightSubsidizedContractRulesHelper;
import com.gridnine.xtrip.server.gds.ibus.FlightTripartiteContractRulesHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightCommissionActionSet;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.impl.standard.common.IntegrationBusHelper;
import com.gridnine.xtrip.server.model.handlers.rules.AirRulesHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class FlightsCommissionsCalculateCommissionsProcessor
extends BaseProcessor {
    private final ExchangeRateData NULL = new ExchangeRateData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        PaymentType paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean isTracingActive = gdsTracingSettings != null && gdsTracingSettings.isActive();
        boolean isSaveRulesTraces = isTracingActive && gdsTracingSettings.isSaveRulesTraces();
        boolean isSaveVendorCommissionsData = isTracingActive && gdsTracingSettings.isSaveVendorCommissionsData();
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        CopyOnWriteArraySet messages = new CopyOnWriteArraySet();
        Map contractsMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP);
        Date date = (Date)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP_DATE);
        ConcurrentHashMap exchangeRateDataCache = new ConcurrentHashMap();
        CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
        String parentThreadId = Long.toString(Thread.currentThread().getId());
        String parentThreadName = Thread.currentThread().getName();
        AtomicInteger threadId = new AtomicInteger(1);
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool("standard-flight-commissions-calculator-" + parentThreadId, 10);
        try {
            CountDownLatch barrier = new CountDownLatch(flights.size());
            for (Flight flight : flights) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                service.submit(() -> {
                    try {
                        String currentThreadName = Thread.currentThread().getName();
                        Thread.currentThread().setName(IntegrationBusHelper.getTargetThreadName((String)"gds:standard-flight-commissions-calculator", (String)("flight-" + threadId.getAndIncrement()), (String)parentThreadId, (String)parentThreadName));
                        try {
                            HashMap<DictionaryReference, RuleProxy<FlightPropertySet, FlightCommissionActionSet>> initProxyMap = new HashMap<DictionaryReference, RuleProxy<FlightPropertySet, FlightCommissionActionSet>>();
                            for (DictionaryReference pt : FlightHelper.collectPts((Flight)flight)) {
                                RuleProxy<FlightPropertySet, FlightCommissionActionSet> proxy = (RuleProxy<FlightPropertySet, FlightCommissionActionSet>)initProxyMap.get(pt);
                                if (proxy != null) continue;
                                proxy = this.createProxy(flight, (DictionaryReference<PassengerType>)pt, paymentType, salesContext, isSaveRulesTraces);
                                initProxyMap.put(pt, proxy);
                            }
                            flight.getContractRelations().clear();
                            flight.getVendorCommissionsDebugData().clear();
                            if (isSaveRulesTraces) {
                                String msg = String.format("calculating commissions for flight: %s", GDSHelper.flight2str(flight));
                                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg);
                            }
                            boolean proxyTraced = false;
                            for (Map.Entry entry : initProxyMap.entrySet()) {
                                if (isSaveRulesTraces) {
                                    String msg = String.format("calculating commissions for passenger type: %s", entry.getKey());
                                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg);
                                }
                                RuleProxy initProxy = (RuleProxy)entry.getValue();
                                FlightTripartiteContractRulesHelper.AirTripartiteContractRulesResult tripartiteContractsData = FlightTripartiteContractRulesHelper.applyTripartiteContracts(flight, salesContext, (RuleProxy<FlightPropertySet, FlightCommissionActionSet>)initProxy, (DictionaryReference<PassengerType>)((DictionaryReference)entry.getKey()), messages, (GdsTracingItemBuilder<Flight>)(isSaveRulesTraces ? builder : null));
                                ((FlightPropertySet)((Object)((Object)initProxy.getPropertySet()))).updateTripartiteProperties(flight);
                                if (contractsMap.get(flight) == null) {
                                    if (!isSaveRulesTraces) continue;
                                    String msg = "no contract was found";
                                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg);
                                    continue;
                                }
                                ArrayList contractRelationDescs = new ArrayList(((Map)contractsMap.get(flight)).keySet());
                                SalesChainDescription scDesc = (SalesChainDescription)EntityStorage.get().resolve(flight.getSalesChain().getDescription()).getEntity();
                                contractRelationDescs.sort((o1, o2) -> {
                                    int index1 = scDesc.getContractRelations().indexOf(o1);
                                    int index2 = scDesc.getContractRelations().indexOf(o2);
                                    return index1 - index2;
                                });
                                GdsContractRelationData lastContractRelationData = null;
                                for (EntityReference contractRelationDesc : contractRelationDescs) {
                                    String msg;
                                    List contracts;
                                    CollectedContractData collectedContractData = (CollectedContractData)((Map)contractsMap.get(flight)).get(contractRelationDesc);
                                    if (isSaveRulesTraces) {
                                        String msg2 = String.format("calculating commissions for contract type: %s", contractRelationDesc);
                                        builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg2);
                                    }
                                    ContractType cType = GeneralProductHelper.getContractType((EntityReference)contractRelationDesc);
                                    EntityContainer descriptionCtr = EntityStorage.get().resolve(contractRelationDesc);
                                    PredefinedContractorType predefinedType = ((ContractorDescription)EntityStorage.get().resolve(((ContractRelationDescription)descriptionCtr.getEntity()).getSupplier()).getEntity()).getPredefinedType();
                                    boolean vendorContract = predefinedType != null ? cType == ContractType.VENDOR && predefinedType == PredefinedContractorType.SUPPLIER : cType == ContractType.VENDOR;
                                    Map<String, RuleResultValue> tripartiteResults = tripartiteContractsData.commissions.get(cType);
                                    Contract appliedContract = null;
                                    initProxy.getAppliedRules().clear();
                                    initProxy.getAppliedRuleCategories().clear();
                                    initProxy.setActionSet((Object)new FlightCommissionActionSet(initProxy, (FlightPropertySet)((Object)((Object)initProxy.getPropertySet())), (DictionaryReference<PassengerType>)((DictionaryReference)entry.getKey())));
                                    if (tripartiteResults != null) {
                                        initProxy.getAppliedRuleCategories().addAll(tripartiteResults.keySet());
                                        ((FlightCommissionActionSet)((Object)((Object)initProxy.getActionSet()))).getResults().putAll(tripartiteResults);
                                    }
                                    if ((contracts = collectedContractData.getContractContainers()).isEmpty() && isSaveRulesTraces) {
                                        String msg3 = "no contract was found";
                                        builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg3);
                                    }
                                    if (vendorContract && !tripartiteContractsData.hasTripartiteContracts) {
                                        FlightSubsidizedContractRulesHelper.applySubsidizedContracts(flight, ((CollectedContractData)((Map)contractsMap.get(flight)).get(contractRelationDesc)).getContractContainers(), (FlightPropertySet)((Object)((Object)initProxy.getPropertySet())), (DictionaryReference<PassengerType>)((DictionaryReference)entry.getKey()), date, initProxy.getTracer(), messages);
                                    }
                                    GdsContractRelationData relation = this.addGdsContractRelationData((EntityReference<ContractRelationDescription>)contractRelationDesc, flight, (DictionaryReference<PassengerType>)((DictionaryReference)entry.getKey()));
                                    ExchangeRateData rateData = this.updateServiceData(relation, collectedContractData, flight, (DictionaryReference<PassengerType>)((DictionaryReference)entry.getKey()), lastContractRelationData, contracts, exchangeRateDataCache);
                                    this.updatePropertySetWithMulticurrencyData(relation, (FlightPropertySet)((Object)((Object)initProxy.getPropertySet())), rateData);
                                    lastContractRelationData = relation;
                                    boolean translateSupplierFees = true;
                                    boolean contractSet = false;
                                    boolean technicalProviderContract = cType == ContractType.TECHNICAL_PROVIDER;
                                    for (EntityContainer contract : contracts) {
                                        if (isSaveRulesTraces) {
                                            String msg4 = String.format("applying contract: %s", ((Contract)contract.getEntity()).toString());
                                            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg4);
                                        }
                                        boolean applied = false;
                                        if (((Contract)contract.getEntity()).isNewModel()) {
                                            List rules = ProfileHelper.getRuleContainersData((EntityContainer)contract, (Date)Optional.ofNullable(date).orElse(new Date()));
                                            Iterator iterator = rules.iterator();
                                            while (iterator.hasNext()) {
                                                ProfileHelper.RuleContainerData data = (ProfileHelper.RuleContainerData)iterator.next();
                                                initProxy.setProxyType(Targets.PRODUCT_COMMISSION.getId());
                                                if (technicalProviderContract) {
                                                    initProxy.setProxyType("technical_fee_model_contract".equals(data.getContainer().getUid()) ? Targets.TECHNICAL_FEE.getId() : Targets.TECHNICAL_FEE_SYSTEM.getId());
                                                }
                                                if (!FlightsCommissionsCalculateCommissionsProcessor.applyRules((RuleProxy<FlightPropertySet, FlightCommissionActionSet>)initProxy, (EntityContainer<Contract>)contract, (EntityContainer<? extends BaseRulesContainer>)data.getContainer(), isSaveRulesTraces, isSaveVendorCommissionsData, flight, (GdsTracingItemBuilder<Flight>)builder)) continue;
                                                applied = true;
                                                if (contractSet || data.isTranslateSupplierFees() == null) continue;
                                                translateSupplierFees = data.isTranslateSupplierFees();
                                                contractSet = true;
                                            }
                                        } else {
                                            initProxy.setProxyType(Targets.PRODUCT_COMMISSION.getId());
                                            if (FlightsCommissionsCalculateCommissionsProcessor.applyRules((RuleProxy<FlightPropertySet, FlightCommissionActionSet>)initProxy, (EntityContainer<Contract>)contract, (EntityContainer<? extends BaseRulesContainer>)contract, isSaveRulesTraces, isSaveVendorCommissionsData, flight, (GdsTracingItemBuilder<Flight>)builder)) {
                                                applied = true;
                                                if (!contractSet) {
                                                    for (ContractCustomerInfo item : ((Contract)contract.getEntity()).getCustomers()) {
                                                        EntityReference itemCustomer;
                                                        if (item.getCustomer() == null || !(itemCustomer = item.getCustomer()).equals((Object)collectedContractData.getCustomer()) || item.getStartDate() != null && item.getStartDate().after(date) || item.getEndDate() != null && item.getEndDate().before(date)) continue;
                                                        translateSupplierFees = item.isTranslateSupplierFees();
                                                        relation.getGeneralData().setContract(new NestedEntityReference(contract, (BaseEntity)item));
                                                        relation.getGeneralData().getContractData().setContract(contract.toReference());
                                                        contractSet = true;
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                        if (!applied) continue;
                                        appliedContract = (Contract)contract.getEntity();
                                        if (!isSaveRulesTraces) continue;
                                        String msg5 = "applied contract was set to " + appliedContract.toString();
                                        builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg5);
                                    }
                                    List contractRelations = (List)flight.getContractRelations().get(entry.getKey());
                                    relation.getGeneralData().setTranslateSupplierFees(Boolean.valueOf(translateSupplierFees));
                                    List<GdsCommission> gdsCommissions = ((FlightCommissionActionSet)((Object)((Object)initProxy.getActionSet()))).createCommissions(relation, contractRelations, ((FlightCommissionActionSet)((Object)((Object)initProxy.getActionSet()))).getAllowedPaymentTypes(), rateData, messages, translateSupplierFees);
                                    if (vendorContract) {
                                        Collection vendorCommissions;
                                        BigDecimal value;
                                        String msg6 = "updating vendor commission rate";
                                        if (isSaveRulesTraces && builder != null) {
                                            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg6);
                                        }
                                        if ((value = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)(vendorCommissions = GeneralProductHelper.filterCommissions(gdsCommissions, null, (Set)(MiscUtil.equals((Object)flight.getBlankOwner(), (Object)collectedContractData.getSupplier()) ? new HashSet<GeneralProductHelper.CommissionType>(Arrays.asList(GeneralProductHelper.CommissionType.STANDARD, GeneralProductHelper.CommissionType.BSP)) : Collections.singleton(GeneralProductHelper.CommissionType.STANDARD)), null)))) != null) {
                                            ((FlightPropertySet)((Object)((Object)initProxy.getPropertySet()))).setVendorCommissionValue(value.doubleValue());
                                        }
                                        Double rate = GeneralProductHelper.calculateCommissionsRateAsDouble((Collection)vendorCommissions, (boolean)true);
                                        ((FlightPropertySet)((Object)((Object)initProxy.getPropertySet()))).setVendorCommissionRate(rate);
                                        if (isSaveRulesTraces && builder != null) {
                                            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("vendor commission was set to: rate  = %s, value = %s", rate, value));
                                        }
                                        flight.getSabreExcludeCommissionQualifier().put(entry.getKey(), ((FlightCommissionActionSet)((Object)((Object)initProxy.getActionSet()))).isSabreExcludeCommissionQualifier());
                                    }
                                    if (((FlightPropertySet)((Object)((Object)initProxy.getPropertySet()))).getBspCommissionEquivalentValue() == null) {
                                        BigDecimal commissionEquivalentValue = MiscUtil.guarded((BigDecimal)GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.commissionPropertyTypes, (Set)GeneralProductHelper.bspCommissionTypes, null)));
                                        ((FlightPropertySet)((Object)((Object)initProxy.getPropertySet()))).setBspCommissionEquivalentValue(commissionEquivalentValue);
                                        if (isSaveRulesTraces) {
                                            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("bsp commission equivalent value was set to %s", commissionEquivalentValue));
                                        }
                                    }
                                    for (GdsCommission comm : gdsCommissions) {
                                        if (!isSaveRulesTraces) continue;
                                        StringBuilder sb = new StringBuilder();
                                        ObjectTrace.trace((Appendable)sb, (Object)comm);
                                        String msg7 = String.format("commission calculated\r\n%s", sb);
                                        builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg7);
                                    }
                                    if (appliedContract == null && tripartiteResults == null && isSaveRulesTraces) {
                                        msg = String.format("no contracts were applied to flight %s for contract type %s", GDSHelper.flight2str(flight), cType);
                                        builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, msg);
                                    }
                                    if (!isSaveRulesTraces || proxyTraced) continue;
                                    msg = String.format("trace of proxy:\r\n%s", initProxy.getTracer().getTrace());
                                    builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg);
                                    proxyTraced = true;
                                }
                            }
                        }
                        finally {
                            Thread.currentThread().setName(currentThreadName);
                        }
                    }
                    catch (Throwable t) {
                        exceptions.add(t);
                    }
                    finally {
                        barrier.countDown();
                    }
                });
            }
            barrier.await();
        }
        finally {
            service.dispose();
        }
        for (ValidationMessage message : messages) {
            Message msg = new Message();
            msg.setMessage(message.getMessage());
            msg.setType(MessageType.WARNING);
            ctx.addMessage(msg);
        }
        if (!exceptions.isEmpty()) {
            throw new MultiException(exceptions);
        }
    }

    private static boolean applyRules(RuleProxy<FlightPropertySet, FlightCommissionActionSet> initProxy, EntityContainer<Contract> contract, EntityContainer<? extends BaseRulesContainer> container, boolean isSaveRulesTraces, boolean isSaveVendorCommissionsData, Flight flight, GdsTracingItemBuilder<Flight> builder) throws Exception {
        boolean isSaveVendorCommissions;
        if (isSaveRulesTraces) {
            String msg = String.format("applying container: %s", ((BaseRulesContainer)container.getEntity()).toString());
            builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg);
        }
        HashSet appliedRulesBefore = new HashSet(initProxy.getAppliedRules());
        RuleSet ruleSet = ProfileHelper.getRuleSet(container);
        RuleEngine.applyRules(Collections.singletonList(initProxy), (RuleSet)ruleSet);
        HashSet appliedRulesLocal = new HashSet(initProxy.getAppliedRules());
        appliedRulesLocal.removeAll(appliedRulesBefore);
        boolean bl = isSaveVendorCommissions = isSaveVendorCommissionsData && ((Contract)contract.getEntity()).getContractType() == ContractType.VENDOR;
        if (!appliedRulesLocal.isEmpty()) {
            if (isSaveRulesTraces || isSaveVendorCommissions) {
                for (String ruleUid : appliedRulesLocal) {
                    RuleSettings rule = (RuleSettings)CollectionUtil.find((Iterable)ruleSet.getRules(), (String)ruleUid);
                    int ruleNumber = ruleSet.getRules().indexOf(rule) + 1;
                    if (isSaveRulesTraces) {
                        String msg = String.format("rule was applied: flight = %s, contract = %s, container = %s, rule \u2116 = %s, description:\r\n%s", GDSHelper.flight2str(flight), contract.toReference(), container.toReference(), ruleNumber, rule.getRestrictionsInfo());
                        builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg);
                        builder.registerAppliedRule((BaseEntity)flight, container.toReference(), rule);
                    }
                    if (!isSaveVendorCommissions) continue;
                    DictionaryReference<PassengerType> passengerTypeRef = ((FlightPropertySet)((Object)initProxy.getPropertySet())).getPassengerTypeRef();
                    List vcItems = (List)CollectionUtil.getFromMap((Map)flight.getVendorCommissionsDebugData(), passengerTypeRef, ArrayList::new);
                    rule.getResults().stream().filter(res -> res.getAction() == Actions.SIMPLE_COMMISSION).forEach(res -> {
                        VendorCommissionDebugItem vcItem = new VendorCommissionDebugItem();
                        RuleResultValue value = (RuleResultValue)res.getValue();
                        if (RulesHelper.isRate((RuleResultValue)value)) {
                            vcItem.setRate(Double.valueOf(value.getValue()));
                        } else {
                            vcItem.setAmount(MoneyHelper.buildMoney((double)value.getValue(), (String)value.getCurrencyCode()));
                        }
                        vcItem.setRuleNumber(ruleNumber);
                        vcItem.setContractCaption(container.toReference().getCaption());
                        vcItems.add(vcItem);
                    });
                }
            }
            return true;
        }
        return false;
    }

    void updatePropertySetWithMulticurrencyData(GdsContractRelationData relation, FlightPropertySet propertySet, ExchangeRateData data) {
        if (data != null && data.getRateWithCoefficient() != 0.0 && propertySet.getVendorCommissionValue() != null) {
            propertySet.setVendorCommissionValue(RulesHelper.convert((BigDecimal)BigDecimal.valueOf(propertySet.getVendorCommissionValue()), (ExchangeRateData)data).doubleValue());
        }
        propertySet.setPrice(relation.getServiceData().getTotalPrice());
        propertySet.setPriceCurrency(ContractRelationHelper.currencyCode((ContractRelationGeneralData)relation.getGeneralData()));
    }

    protected ExchangeRateData updateServiceData(GdsContractRelationData relation, CollectedContractData collectedContractData, Flight flight, DictionaryReference<PassengerType> passengerType, GdsContractRelationData lastContractRelationData, List<EntityContainer<Contract>> contracts, Map<String, ExchangeRateData> exchangeRateDataCache) {
        ExchangeRateData data;
        String curCode;
        EntityContainer<Contract> contractCtr;
        ContractRelationGeneralData generalData = relation.getGeneralData();
        if (contracts.size() == 1 && ((Contract)contracts.get(0).getEntity()).isNewModel()) {
            contractCtr = contracts.get(0);
            generalData.setContract(((Contract)contractCtr.getEntity()).getCustomers().isEmpty() ? null : new NestedEntityReference(contractCtr, (BaseEntity)((Contract)contractCtr.getEntity()).getCustomers().get(0)));
        } else {
            Date date = new Date();
            NestedEntityReference ref = AirRulesHelper.buildContractNestedRef(contracts, (EntityReference)collectedContractData.getCustomer(), (Date)date);
            contractCtr = ref != null ? (EntityContainer)contracts.stream().filter(c -> ref.getUid().equals(c.getUid())).findFirst().orElse(null) : null;
            generalData.setContract(ref);
        }
        generalData.getContractData().setContract(contractCtr != null ? contractCtr.toReference() : null);
        generalData.setTranslateSupplierFees(null);
        generalData.setCalculationDate(new Date());
        String string = curCode = lastContractRelationData == null || lastContractRelationData.getGeneralData().getCurrency() == null ? null : lastContractRelationData.getGeneralData().getCurrency().getCode();
        if (curCode == null) {
            curCode = flight.getGdsCurrencyCode() == null ? DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB") : flight.getGdsCurrencyCode();
        }
        String key = this.buildRateDataCacheKey(curCode, contracts);
        String lastCurrency = curCode;
        if (!exchangeRateDataCache.containsKey(key)) {
            data = RulesHelper.getExchangeRateData(contracts, (EntityReference)collectedContractData.getCustomer(), (Date)new Date(), null, (String)lastCurrency, (boolean)true);
            exchangeRateDataCache.put(key, data != null ? data : this.NULL);
        }
        data = exchangeRateDataCache.get(key);
        generalData.setRate(data);
        if (lastContractRelationData == null) {
            generalData.setCurrency((DictionaryReference)new CurrencyInfoReference(curCode));
            BigDecimal fare = MiscUtil.guarded((BigDecimal)RulesHelper.convert((BigDecimal)FlightHelper.getEquivalentFare((Flight)flight, passengerType), (ExchangeRateData)data));
            relation.getServiceData().getDetalization().setFare(fare);
            BigDecimal total = fare;
            for (SimpleTax tax : FlightHelper.buildSimpleTaxes((Flight)flight, passengerType)) {
                tax.setAmount(RulesHelper.convert((BigDecimal)tax.getAmount(), (ExchangeRateData)data));
                relation.getServiceData().getDetalization().getTaxes().add(tax);
                total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, tax.getAmount()});
            }
            relation.getServiceData().setTotalPrice(total);
            relation.getServiceData().setPaymentPrice(total);
            if (data == this.NULL || curCode.equals(data.getCurrency().getCode())) {
                return null;
            }
            generalData.setCurrency(data.getCurrency());
            return data;
        }
        BigDecimal fare = MiscUtil.guarded((BigDecimal)RulesHelper.convert((BigDecimal)lastContractRelationData.getServiceData().getDetalization().getFare(), (ExchangeRateData)data));
        relation.getServiceData().getDetalization().setFare(fare);
        BigDecimal total = fare;
        for (SimpleTax tax : lastContractRelationData.getServiceData().getDetalization().getTaxes()) {
            SimpleTax tax2 = new SimpleTax();
            tax2.setCode(tax.getCode());
            tax2.setAmount(RulesHelper.convert((BigDecimal)tax.getAmount(), (ExchangeRateData)data));
            relation.getServiceData().getDetalization().getTaxes().add(tax2);
            total = MiscUtil.sum((BigDecimal[])new BigDecimal[]{total, tax2.getAmount()});
        }
        relation.getServiceData().setTotalPrice(total);
        relation.getServiceData().setPaymentPrice(total);
        generalData.setCurrency((DictionaryReference)(data.getCurrency() == null ? new CurrencyInfoReference(curCode) : data.getCurrency()));
        if (data == this.NULL || curCode.equals(data.getCurrency().getCode())) {
            return null;
        }
        return data;
    }

    protected GdsContractRelationData addGdsContractRelationData(EntityReference<ContractRelationDescription> contractRelationDesc, Flight flight, DictionaryReference<PassengerType> passengerType) {
        GdsContractRelationData gdsContractRelData = new GdsContractRelationData();
        gdsContractRelData.setDescription(contractRelationDesc);
        gdsContractRelData.getGeneralData().setCalculationDate(new Date());
        if (!flight.getContractRelations().containsKey(passengerType)) {
            flight.getContractRelations().put(passengerType, new ArrayList());
        }
        ((List)flight.getContractRelations().get(passengerType)).add(gdsContractRelData);
        return gdsContractRelData;
    }

    private String buildRateDataCacheKey(String curCode, List<EntityContainer<Contract>> contracts) {
        StringBuilder keyBuf = new StringBuilder(curCode);
        for (EntityContainer<Contract> contract : contracts) {
            keyBuf.append(contract.getUid());
        }
        return keyBuf.toString();
    }

    protected RuleProxy<FlightPropertySet, FlightCommissionActionSet> createProxy(Flight flight, DictionaryReference<PassengerType> passengerType, PaymentType paymentType, SalesContext ctx, boolean proxyTracerEnabled) {
        RuleProxy result = new RuleProxy();
        result.getTracer().setDisabled(!proxyTracerEnabled);
        result.setProxyType(Targets.PRODUCT_COMMISSION.getId());
        result.setProxyDate(new Date());
        result.setPropertySet((Object)FlightPropertySet.create(flight, passengerType, paymentType, null, result, ctx));
        return result;
    }

    static class FlightMulticurrencyData {
        final ExchangeRateData rateData;
        final String currencyCode;

        FlightMulticurrencyData(ExchangeRateData rateData, String currencyCode) {
            this.rateData = rateData;
            this.currencyCode = currencyCode;
        }
    }
}

