/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.CollectedContractData;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.rules.standard.ContractActions;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightCommissionActionSet;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FlightsCommissionsCollectContractsProcessor
extends BaseProcessor {
    private static final Function<RuleProxy, Boolean> IS_CONTRACT_SELECTED_PREDICATE = p -> Boolean.TRUE.equals(((FlightCommissionActionSet)((Object)((Object)p.getActionSet()))).isContractSelected());

    public void process(MessageContext ctx) throws Exception {
        GeneralProductHelper.ensureContractRelationsExists();
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        PaymentType paymentType = (PaymentType)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.PAYMENT_TYPE);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean trace = builder != null && gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        FlightsCommissionsCollectContractsProcessor.initBuilderLog(salesContext, (GdsTracingItemBuilder<Flight>)builder, trace);
        Date now = new Date();
        HashMap contractsMap = new HashMap();
        for (Map.Entry<SalesChain, List<Flight>> entry : this.getSalesChains(flights).entrySet()) {
            SalesChain flightSalesChain = entry.getKey();
            Map<EntityReference<ContractRelationDescription>, CollectedContractData> collectedContracts = this.collectContracts(flightSalesChain, now, (GdsTracingItemBuilder<Flight>)builder, trace);
            for (Flight flight : entry.getValue()) {
                LinkedHashMap<EntityReference<ContractRelationDescription>, CollectedContractData> contracts = new LinkedHashMap<EntityReference<ContractRelationDescription>, CollectedContractData>();
                EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)flight.getSalesChain(), (PredefinedContractorType)PredefinedContractorType.SUPPLIER);
                for (Map.Entry<EntityReference<ContractRelationDescription>, CollectedContractData> relationEntry : collectedContracts.entrySet()) {
                    List containersNewModel;
                    ArrayList<EntityContainer<Contract>> filteredContracts = new ArrayList<EntityContainer>();
                    EntityReference<ContractRelationDescription> relationDescriptionRef = relationEntry.getKey();
                    ContractType cType = GeneralProductHelper.getContractType(relationDescriptionRef);
                    for (EntityContainer item : relationEntry.getValue().getContractContainers()) {
                        if (((Contract)item.getEntity()).getVendor() != null && !((Contract)item.getEntity()).getVendor().equals((Object)flight.getBlankOwner()) || cType == ContractType.VENDOR && ((Contract)item.getEntity()).getSupplier() != null && !((Contract)item.getEntity()).getSupplier().equals((Object)supplier)) continue;
                        filteredContracts.add(item);
                    }
                    if (CollectionUtil.isNotEmpty(filteredContracts) && CollectionUtil.isNotEmpty(containersNewModel = filteredContracts.stream().filter(c -> ((Contract)c.getEntity()).isNewModel()).collect(Collectors.toList()))) {
                        DictionaryReference passengerType;
                        filteredContracts = containersNewModel;
                        this.writeLogAndBuilder("exclude OLD contracts of type %s", (GdsTracingItemBuilder<Flight>)builder, trace, flight, cType.toString());
                        EntityContainer<Contract> contract = null;
                        Iterator iterator = FlightHelper.collectPts((Flight)flight).iterator();
                        while (iterator.hasNext() && (contract = this.getContract(flightSalesChain, relationDescriptionRef, filteredContracts, flight, (DictionaryReference<PassengerType>)(passengerType = (DictionaryReference)iterator.next()), paymentType, salesContext, now, (GdsTracingItemBuilder<Flight>)builder, trace)) == null) {
                        }
                        if (contract != null) {
                            filteredContracts = Collections.singletonList(contract);
                            this.writeLogAndBuilder("add contractType: %s, contract %s", (GdsTracingItemBuilder<Flight>)builder, trace, flight, cType.toString(), ((Contract)contract.getEntity()).toString());
                        } else {
                            filteredContracts = Collections.emptyList();
                        }
                    }
                    CollectedContractData data = new CollectedContractData();
                    data.setCustomer(relationEntry.getValue().getCustomer());
                    data.setSupplier(relationEntry.getValue().getSupplier());
                    data.getContractContainers().addAll(filteredContracts);
                    contracts.put(relationDescriptionRef, data);
                }
                contractsMap.put(flight, contracts);
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP, contractsMap);
        ctx.putObject((Enum)IBusGdsContextKeys.CONTRACTS_MAP_DATE, (Object)now);
    }

    private Map<EntityReference<ContractRelationDescription>, CollectedContractData> collectContracts(SalesChain flightSalesChain, Date date, GdsTracingItemBuilder<Flight> builder, boolean trace) {
        SalesChainDescription salesChainDescription = (SalesChainDescription)EntityStorage.get().resolve(flightSalesChain.getDescription()).getEntity();
        List contractRelations = salesChainDescription.getContractRelations();
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
        LinkedHashMap<EntityReference<ContractRelationDescription>, CollectedContractData> result = new LinkedHashMap<EntityReference<ContractRelationDescription>, CollectedContractData>();
        for (EntityReference relationDescriptionRef : contractRelations) {
            this.writeLogAndBuilder("collecting contracts of type %s", builder, trace, relationDescriptionRef.toString());
            EntityContainer descr = EntityStorage.get().resolve(relationDescriptionRef);
            EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)flightSalesChain, (EntityReference)((ContractRelationDescription)descr.getEntity()).getSupplier());
            EntityReference customer = GeneralProductHelper.getContractor((SalesChain)flightSalesChain, (EntityReference)((ContractRelationDescription)descr.getEntity()).getCustomer());
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relationDescriptionRef);
            CollectedContractData data = new CollectedContractData();
            data.setSupplier(supplier);
            data.setCustomer(customer);
            this.getNewContracts(data, contractType, date, builder, trace, (EntityReference<Organization>)allAgenciesProfile, (EntityReference<Organization>)allClientsProfile);
            this.getOldContracts(data, contractType, date, builder, trace, (EntityReference<Organization>)allAgenciesProfile, (EntityReference<Organization>)allClientsProfile);
            result.put((EntityReference<ContractRelationDescription>)relationDescriptionRef, data);
            if (!data.getContractContainers().isEmpty()) continue;
            this.writeLogAndBuilder("no contract of type %s was collected", builder, trace, relationDescriptionRef.toString());
        }
        return result;
    }

    private void getNewContracts(CollectedContractData data, ContractType contractType, Date date, GdsTracingItemBuilder<Flight> builder, boolean trace, EntityReference<Organization> allAgenciesProfile, EntityReference<Organization> allClientsProfile) {
        SearchCriterion typeSpecificCriterion;
        EntityReference supplier = data.getSupplier();
        EntityReference customer = data.getCustomer();
        switch (contractType) {
            case VENDOR: {
                SearchCriterion hCustCrit = SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)customer);
                typeSpecificCriterion = allAgenciesProfile == null ? hCustCrit : SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{hCustCrit, SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), allAgenciesProfile)});
                if (supplier == null) break;
                typeSpecificCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{typeSpecificCriterion, SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier)});
                break;
            }
            case TECHNICAL_PROVIDER: {
                typeSpecificCriterion = SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier);
                break;
            }
            case SUBAGENCY: {
                if (customer == null || supplier == null || customer.equals((Object)supplier)) {
                    return;
                }
                if (allAgenciesProfile == null) {
                    typeSpecificCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customer), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)supplier)});
                    break;
                }
                typeSpecificCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customer), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), allAgenciesProfile)}), SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)supplier), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), allAgenciesProfile)})});
                break;
            }
            default: {
                SearchCriterion hCustCrit = SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)customer);
                if (allClientsProfile != null) {
                    hCustCrit = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{hCustCrit, SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), allClientsProfile)});
                }
                SearchCriterion hSuppCrit = SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier);
                if (allAgenciesProfile != null) {
                    hSuppCrit = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{hSuppCrit, SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), allAgenciesProfile)});
                }
                typeSpecificCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{hCustCrit, hSuppCrit});
            }
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)true));
        query.getCriteria().getCriterions().add(typeSpecificCriterion);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)contractType));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.provider.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.transferProvider.name(), null));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        ArrayList<EntityContainer> contracts = new ArrayList<EntityContainer>();
        ArrayList contractIndexes = new ArrayList(EntityStorage.get().search(ContractIndex.class, query, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS).getData());
        contractIndexes.sort((o1, o2) -> {
            int index2;
            if (o1.isDefaultContract() != o2.isDefaultContract()) {
                return o1.isDefaultContract() ? -1 : 1;
            }
            int index1 = this.getIndex(allAgenciesProfile, allClientsProfile, (ContractIndex)o1);
            if (index1 != (index2 = this.getIndex(allAgenciesProfile, allClientsProfile, (ContractIndex)o2))) {
                return index1 > index2 ? 1 : -1;
            }
            return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
        });
        for (ContractIndex index : contractIndexes) {
            EntityContainer ctr = EntityStorage.get().resolve(index.getSource());
            if (contracts.contains(ctr)) continue;
            contracts.add(ctr);
            this.writeLogAndBuilder("found NEW contract %s", builder, trace, ((Contract)ctr.getEntity()).toString());
        }
        data.getContractContainers().addAll(contracts);
    }

    private int getIndex(EntityReference<Organization> allAgenciesProfile, EntityReference<Organization> allClientsProfile, ContractIndex o) {
        return (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o.getSupplier()) ? 4 : 0) + (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o.getCustomer()) ? 2 : 0) + (allClientsProfile != null && allClientsProfile.equals((Object)o.getCustomer()) ? 1 : 0);
    }

    public EntityContainer<Contract> getContract(SalesChain flightSalesChain, EntityReference<ContractRelationDescription> relationDescriptionRef, Collection<EntityContainer<Contract>> contracts, Flight flight, DictionaryReference<PassengerType> passengerType, PaymentType paymentType, SalesContext salesContext, Date date, GdsTracingItemBuilder<Flight> builder, boolean proxyTracerEnabled) throws Exception {
        List sortedByDefaultContracts;
        boolean isOnlyOldContracts = contracts.stream().noneMatch(ctr -> ((Contract)ctr.getEntity()).isNewModel());
        List<Object> filteredContracts = Collections.emptyList();
        if (contracts.size() == 1 || isOnlyOldContracts) {
            filteredContracts = new ArrayList<EntityContainer<Contract>>(contracts);
        } else {
            EntityContainer descr = EntityStorage.get().resolve(relationDescriptionRef);
            EntityReference supplier = GeneralProductHelper.getContractor((SalesChain)flightSalesChain, (EntityReference)((ContractRelationDescription)descr.getEntity()).getSupplier());
            EntityReference customer = GeneralProductHelper.getContractor((SalesChain)flightSalesChain, (EntityReference)((ContractRelationDescription)descr.getEntity()).getCustomer());
            ContractType contractType = GeneralProductHelper.getContractType(relationDescriptionRef);
            EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
            EntityReference allClientsProfile = ProfileDao.findAllClientsProfile();
            filteredContracts = contracts.stream().filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getSupplier(), (Object)supplier)).filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getCustomer(), (Object)customer)).collect(Collectors.toList());
            if (filteredContracts.isEmpty() && allAgenciesProfile != null) {
                filteredContracts = contracts.stream().filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getSupplier(), (Object)allAgenciesProfile)).filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getCustomer(), (Object)customer)).collect(Collectors.toList());
            }
            if (filteredContracts.isEmpty()) {
                if (contractType.equals((Object)ContractType.CLIENT) && allClientsProfile != null) {
                    filteredContracts = contracts.stream().filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getSupplier(), (Object)supplier)).filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getCustomer(), (Object)allClientsProfile)).collect(Collectors.toList());
                } else if (contractType.equals((Object)ContractType.SUBAGENCY) && allAgenciesProfile != null) {
                    filteredContracts = contracts.stream().filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getSupplier(), (Object)supplier)).filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getCustomer(), (Object)allAgenciesProfile)).collect(Collectors.toList());
                }
            }
            if (filteredContracts.isEmpty()) {
                if (contractType.equals((Object)ContractType.CLIENT) && allAgenciesProfile != null && allClientsProfile != null) {
                    filteredContracts = contracts.stream().filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getSupplier(), (Object)allAgenciesProfile)).filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getCustomer(), (Object)allClientsProfile)).collect(Collectors.toList());
                } else if (contractType.equals((Object)ContractType.SUBAGENCY) && allAgenciesProfile != null) {
                    filteredContracts = contracts.stream().filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getSupplier(), (Object)allAgenciesProfile)).filter(ctr -> MiscUtil.equals((Object)((Contract)ctr.getEntity()).getCustomer(), (Object)allAgenciesProfile)).collect(Collectors.toList());
                }
            }
            if (filteredContracts.isEmpty()) {
                filteredContracts = new ArrayList<EntityContainer<Contract>>(contracts);
            }
        }
        if (filteredContracts.size() > 1) {
            RuleProxy<FlightPropertySet, FlightCommissionActionSet> proxy = this.createProxy(flight, passengerType, paymentType, salesContext, proxyTracerEnabled);
            proxy.setContractType(ContractType.VENDOR.name());
            proxy.setStopPredicate(IS_CONTRACT_SELECTED_PREDICATE);
            proxy.getDesiredRuleCategories().add(ContractActions.CONTRACT.getRuleCategoryValue(null, null));
            for (EntityContainer contract : filteredContracts) {
                proxy.setActionSet((Object)new FlightCommissionActionSet(proxy, (FlightPropertySet)((Object)proxy.getPropertySet()), passengerType));
                List rules = ProfileHelper.getRuleContainers((EntityContainer)contract, (Date)(date != null ? date : new Date()));
                for (EntityContainer rulesContainer : rules) {
                    RuleSet ruleSet = ProfileHelper.getRuleSet((EntityContainer)rulesContainer);
                    if (ruleSet == null) continue;
                    RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
                    if (!Boolean.TRUE.equals(((FlightCommissionActionSet)((Object)proxy.getActionSet())).isContractSelected())) continue;
                    return contract;
                }
            }
        }
        if (!(sortedByDefaultContracts = filteredContracts.stream().sorted((o1, o2) -> {
            if (((Contract)o1.getEntity()).isDefaultContract() != ((Contract)o2.getEntity()).isDefaultContract()) {
                return ((Contract)o1.getEntity()).isDefaultContract() ? -1 : 1;
            }
            return -MiscUtil.compare((Date)((Contract)o1.getEntity()).getIssueDate(), (Date)((Contract)o2.getEntity()).getIssueDate(), (boolean)true);
        }).collect(Collectors.toList())).isEmpty()) {
            EntityContainer contract = (EntityContainer)sortedByDefaultContracts.get(0);
            if (sortedByDefaultContracts.size() == 1 || ((Contract)contract.getEntity()).isDefaultContract() && !((Contract)((EntityContainer)sortedByDefaultContracts.get(1)).getEntity()).isDefaultContract()) {
                return contract;
            }
            if (proxyTracerEnabled) {
                List entities2 = sortedByDefaultContracts.stream().map(EntityContainer::getEntity).collect(Collectors.toList());
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, "found contracts: " + entities2);
                StringBuilder msg = new StringBuilder("contract not selected, ");
                if (((Contract)contract.getEntity()).isDefaultContract() && ((Contract)((EntityContainer)sortedByDefaultContracts.get(1)).getEntity()).isDefaultContract()) {
                    String nameContracts = entities2.stream().filter(Contract::isDefaultContract).map(Contract::getName).collect(Collectors.joining(", "));
                    msg.append("there are many main contracts: ").append(nameContracts);
                } else if (!((Contract)contract.getEntity()).isDefaultContract() && !((Contract)((EntityContainer)sortedByDefaultContracts.get(1)).getEntity()).isDefaultContract()) {
                    msg.append("all contracts are not main");
                }
                builder.traceFlightLogic((BaseEntity)flight, MessageType.WARNING, msg.toString());
            }
        }
        return null;
    }

    protected RuleProxy<FlightPropertySet, FlightCommissionActionSet> createProxy(Flight flight, DictionaryReference<PassengerType> passengerType, PaymentType paymentType, SalesContext ctx, boolean proxyTracerEnabled) {
        RuleProxy result = new RuleProxy();
        result.getTracer().setDisabled(!proxyTracerEnabled);
        result.setProxyType(Targets.PRODUCT_COMMISSION.getId());
        result.setProxyDate(new Date());
        result.setPropertySet((Object)FlightPropertySet.create(flight, passengerType, paymentType, null, result, ctx));
        return result;
    }

    private void getOldContracts(CollectedContractData data, ContractType contractType, Date date, GdsTracingItemBuilder<Flight> builder, boolean trace, final EntityReference<Organization> allAgenciesProfile, final EntityReference<Organization> allClientsProfile) {
        SearchCriterion typeSpecificCriterion;
        EntityReference supplier = data.getSupplier();
        EntityReference customer = data.getCustomer();
        data.setSupplier(supplier);
        data.setCustomer(customer);
        switch (contractType) {
            case VENDOR: {
                SearchCriterion hCustCrit = SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customer);
                if (allAgenciesProfile == null) {
                    typeSpecificCriterion = hCustCrit;
                    break;
                }
                typeSpecificCriterion = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{hCustCrit, SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), allAgenciesProfile)});
                break;
            }
            case SUBAGENCY: {
                if (customer == null || supplier == null || customer.equals((Object)supplier)) {
                    return;
                }
                if (allAgenciesProfile == null) {
                    typeSpecificCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customer), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)supplier)});
                    break;
                }
                typeSpecificCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customer), SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), allAgenciesProfile)}), SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)supplier), SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), allAgenciesProfile)})});
                break;
            }
            default: {
                SearchCriterion hCustCrit = SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customer);
                if (allClientsProfile != null) {
                    hCustCrit = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{hCustCrit, SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), allClientsProfile)});
                }
                SearchCriterion hSuppCrit = SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)supplier);
                if (allAgenciesProfile != null) {
                    hSuppCrit = SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{hSuppCrit, SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), allAgenciesProfile)});
                }
                typeSpecificCriterion = SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{hCustCrit, hSuppCrit});
            }
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null)}));
        query.getCriteria().getCriterions().add(typeSpecificCriterion);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)date))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)date))}));
        ArrayList<EntityContainer> contracts = new ArrayList<EntityContainer>();
        final HashMap<EntityReference, EntityContainer> contractsMap = new HashMap<EntityReference, EntityContainer>();
        ArrayList<ContractCustomerIndex> contractIndexes = new ArrayList<ContractCustomerIndex>(EntityStorage.get().search(ContractCustomerIndex.class, query, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS).getData());
        for (ContractCustomerIndex item : contractIndexes) {
            contractsMap.put(item.getSource(), EntityStorage.get().resolve(item.getSource()));
        }
        contractIndexes.sort(new Comparator<ContractCustomerIndex>(){

            @Override
            public int compare(ContractCustomerIndex o1, ContractCustomerIndex o2) {
                int index2;
                EntityContainer ctr1 = (EntityContainer)contractsMap.get(o1.getSource());
                EntityContainer ctr2 = (EntityContainer)contractsMap.get(o2.getSource());
                if (ctr1 == null) {
                    return ctr2 == null ? 0 : 1;
                }
                if (ctr2 == null) {
                    return -1;
                }
                if (((Contract)ctr1.getEntity()).getPriority() != ((Contract)ctr2.getEntity()).getPriority()) {
                    return ((Contract)ctr1.getEntity()).getPriority() > ((Contract)ctr2.getEntity()).getPriority() ? -1 : 1;
                }
                int index1 = this.getGeneralityIndex(o1);
                if (index1 != (index2 = this.getGeneralityIndex(o2))) {
                    return index1 > index2 ? 1 : -1;
                }
                if (((Contract)ctr1.getEntity()).isTypicalContract() != ((Contract)ctr2.getEntity()).isTypicalContract()) {
                    return ((Contract)ctr1.getEntity()).isTypicalContract() ? 1 : -1;
                }
                return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
            }

            private int getGeneralityIndex(ContractCustomerIndex o1) {
                return (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getSupplier()) ? 4 : 0) + (allAgenciesProfile != null && allAgenciesProfile.equals((Object)o1.getCustomer()) ? 2 : 0) + (allClientsProfile != null && allClientsProfile.equals((Object)o1.getCustomer()) ? 1 : 0);
            }
        });
        for (ContractCustomerIndex index : contractIndexes) {
            EntityContainer ctr = (EntityContainer)contractsMap.get(index.getSource());
            if (ctr == null || contracts.contains(ctr)) continue;
            contracts.add(ctr);
            this.writeLogAndBuilder("added OLD contract %s", builder, trace, ((Contract)ctr.getEntity()).toString());
        }
        data.getContractContainers().addAll(contracts);
    }

    private Map<SalesChain, List<Flight>> getSalesChains(Collection<Flight> flights) {
        HashMap<SalesChain, List<Flight>> result = new HashMap<SalesChain, List<Flight>>();
        for (Flight flight : flights) {
            SalesChain salesChain = null;
            for (SalesChain sc : result.keySet()) {
                if (!this.equalsSalesChains(sc, flight.getSalesChain())) continue;
                salesChain = sc;
                break;
            }
            if (salesChain != null) {
                ((List)result.get(salesChain)).add(flight);
                continue;
            }
            salesChain = flight.getSalesChain();
            ArrayList<Flight> scFlights = new ArrayList<Flight>();
            scFlights.add(flight);
            result.put(salesChain, scFlights);
        }
        return result;
    }

    private boolean equalsSalesChains(SalesChain sc1, SalesChain sc2) {
        if (sc1 == null || sc2 == null) {
            return false;
        }
        if (!sc1.getDescription().equals((Object)sc2.getDescription())) {
            return false;
        }
        if (sc1.getContractors().size() != sc2.getContractors().size()) {
            return false;
        }
        for (Contractor c1 : sc1.getContractors()) {
            boolean found = false;
            for (Contractor c2 : sc2.getContractors()) {
                if (!MiscUtil.equals((Object)c1.getContractor(), (Object)c2.getContractor()) || !MiscUtil.equals((Object)c1.getDescription(), (Object)c2.getDescription())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static void initBuilderLog(SalesContext salesContext, GdsTracingItemBuilder<Flight> builder, boolean trace) throws IOException {
        if (trace) {
            StringBuilder sb = new StringBuilder();
            ObjectTrace.trace((Appendable)sb, (Object)salesContext);
            String msg = FlightsCommissionsCollectContractsProcessor.writeBuilder("calculating commissions for sales context\r\n%s", builder, trace, null, sb.toString());
            builder.traceGlobalLogic(MessageType.MESSAGE, msg);
        }
    }

    private void writeLogAndBuilder(String format, GdsTracingItemBuilder<Flight> builder, boolean trace, String ... args) {
        this.writeLogAndBuilder(format, builder, trace, (Flight)null, args);
    }

    private void writeLogAndBuilder(String format, GdsTracingItemBuilder<Flight> builder, boolean trace, Flight flight, String ... args) {
        this.log.debug(FlightsCommissionsCollectContractsProcessor.writeBuilder(format, builder, trace, flight, args));
    }

    private static String writeBuilder(String format, GdsTracingItemBuilder<Flight> builder, boolean trace, Flight flight, String ... args) {
        String msg = String.format(format, Arrays.stream(args).toArray());
        if (trace) {
            if (flight == null) {
                builder.traceGlobalLogic(MessageType.MESSAGE, msg);
            } else {
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, msg);
            }
        }
        return msg;
    }
}

