/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsOperation;
import com.gridnine.xtrip.common.gds.model.GdsOperationsProperties;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class GdsOperationAvailabilityProvider
extends BaseRoutingKeyProvider {
    private GdsOperation operation;
    private boolean defaultAvailability;

    public void configure(Map<String, String> parameters) {
        this.operation = GdsOperation.valueOf((String)parameters.get("operation"));
        this.defaultAvailability = Boolean.parseBoolean(parameters.get("default-availability"));
    }

    public String getRoutingKey(MessageContext ctx) throws Exception {
        Flight flight;
        GdsOperationsProperties opProps = null;
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        if (reservation != null) {
            opProps = reservation.getGdsOperationsProperties();
        }
        if (reservation == null && (flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT)) != null) {
            opProps = flight.getGdsOperationsProperties();
        }
        return String.valueOf(GDSHelper.isGdsOperationAvailable(this.operation, opProps, this.defaultAvailability));
    }
}

