/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.FlightPropertySet;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;

public class GdsParametersExForFlightProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        DictionaryReference passengerType = (DictionaryReference)ctx.getObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        GdsTracingItemBuilder builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        boolean trace = builder != null && gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GDSParametersActions gdsParametersActions = this.applyRules(rules, flight, salesContext, trace, (DictionaryReference<PassengerType>)passengerType, (GdsTracingItemBuilder<Flight>)builder, ctx);
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS, (Object)gdsParametersActions);
        if (passengerType != null) {
            ctx.removeObject((Enum)IBusMidofficeContextKeys.PASSENGER_TYPE);
        }
    }

    private GDSParametersActions applyRules(RuleSet rules, Flight flight, SalesContext salesContext, boolean proxyTracerEnabled, DictionaryReference<PassengerType> passengerType, GdsTracingItemBuilder<Flight> builder, MessageContext ctx) throws Exception {
        RuleProxy<FlightPropertySet, GDSParametersActions> proxy = this.createProxy(flight, salesContext, proxyTracerEnabled, passengerType);
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        if (proxyTracerEnabled) {
            EntityReference rulesContainerRef = (EntityReference)ctx.getObject((Enum)IBusGdsContextKeys.SALES_POINT_FOR_RULES);
            for (String ruleUid : proxy.getAppliedRules()) {
                RuleSettings rule = (RuleSettings)CollectionUtil.find((Iterable)rules.getRules(), (String)ruleUid);
                if (rule == null) continue;
                builder.traceFlightLogic((BaseEntity)flight, MessageType.MESSAGE, String.format("rule %s was applied: %s", Integer.toString(rules.getRules().indexOf(rule) + 1), rule.getRestrictionsInfo()));
                builder.registerAppliedRule((BaseEntity)flight, rulesContainerRef, rule);
            }
        }
        return (GDSParametersActions)proxy.getActionSet();
    }

    protected RuleProxy<FlightPropertySet, GDSParametersActions> createProxy(Flight flight, SalesContext salesContext, boolean proxyTracerEnabled, DictionaryReference<PassengerType> passengerType) {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(Targets.GDS_PARAMETERS_EX.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)FlightPropertySet.create(flight, passengerType, PaymentType.INVOICE, null, proxy, salesContext));
        proxy.setActionSet((Object)new GDSParametersActions());
        return proxy;
    }
}

