/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersProperties;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;

public class GdsParametersForFlightSearchParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        RuleSet rules = (RuleSet)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.RULES);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        boolean trace = gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveRulesTraces();
        GDSParametersActions gdsParametersActions = this.applyRules(rules, fsp, salesContext, (EntityContainer<BaseGdsAccount>)gdsAccountCtr, trace);
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS, (Object)gdsParametersActions);
    }

    private GDSParametersActions applyRules(RuleSet rules, FlightSearchParameters fsp, SalesContext salesContext, EntityContainer<BaseGdsAccount> gdsAccountCtr, boolean proxyTracerEnabled) throws Exception {
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!proxyTracerEnabled);
        proxy.setProxyType(Targets.GDS_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        proxy.setPropertySet((Object)new GDSParametersProperties(fsp.getRoute(), salesContext, ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds(), (EntityReference<BaseGdsAccount>)gdsAccountCtr.toReference(), proxy));
        proxy.setActionSet((Object)new GDSParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        return (GDSParametersActions)proxy.getActionSet();
    }
}

