/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocumentPart;
import com.gridnine.xtrip.common.gds.model.GdsTracingSearchItem;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.GdsTracingFlightItemBuilder;
import java.util.AbstractMap;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class GdsTracingFlightItemBuilderTest {
    @Test
    public void getTitleWorksWithFlightSegments() {
        GdsTracingFlightItemBuilder testObject = this.createFlightSegmentFilledTestObject(new Flight());
        GdsTracingDocumentPart result = testObject.buildGdsTracingDocumentPart("test");
        Assert.assertNotNull((Object)((GdsTracingSearchItem)result.getVariants().get(0)).getTitle());
        Assert.assertEquals((Object)"", (Object)((GdsTracingSearchItem)result.getVariants().get(0)).getTitle());
    }

    @Test
    public void getTitleIsSetCorrectlyForFlightSegments() {
        Flight flight = new Flight();
        FlightSegmentTariff fst = new FlightSegmentTariff();
        FlightSegment flightSegment = new FlightSegment();
        AirlineReference airlineRef = new AirlineReference();
        airlineRef.setCode("SU");
        flightSegment.setAirline((DictionaryReference)airlineRef);
        flightSegment.setFlightNumber("555");
        fst.getSegments().add(flightSegment);
        flight.getSegmentTariffs().add(fst);
        GdsTracingFlightItemBuilder testObject = this.createFlightSegmentFilledTestObject(flight);
        GdsTracingDocumentPart result = testObject.buildGdsTracingDocumentPart("test");
        Assert.assertNotNull((Object)((GdsTracingSearchItem)result.getVariants().get(0)).getTitle());
        Assert.assertEquals((Object)"SU555", (Object)((GdsTracingSearchItem)result.getVariants().get(0)).getTitle());
    }

    protected GdsTracingFlightItemBuilder createFlightSegmentFilledTestObject(Flight flight) {
        GdsTracingFlightItemBuilder testObject = (GdsTracingFlightItemBuilder)((Object)Mockito.spy((Object)((Object)new GdsTracingFlightItemBuilder())));
        AbstractMap.SimpleEntry<Flight, GdsTracingItemBuilder.VariantData> entry = new AbstractMap.SimpleEntry<Flight, GdsTracingItemBuilder.VariantData>(flight, new GdsTracingItemBuilder.VariantData());
        ((GdsTracingFlightItemBuilder)((Object)Mockito.doReturn(Collections.singleton(entry)).when((Object)testObject))).variantsDataEntries();
        return testObject;
    }
}

