/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.rules.GdsPropertiesProvider;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GdsTripartiteHelper {
    public static Map<DictionaryReference<Airline>, Collection<String>> getCodes(SalesContext salesContext, EntityContainer<BaseGdsAccount> gdsAccountCtr, Collection<DictionaryReference<Airline>> airlines, EntityReference[] agencies, RuleAction action) {
        HashMap<DictionaryReference<Airline>, Collection<String>> result = new HashMap<DictionaryReference<Airline>, Collection<String>>();
        for (EntityContainer<TripartiteContract> entityContainer : IBusGdsHelper.collectTripartiteContracts(salesContext, airlines, agencies)) {
            if (((TripartiteContract)entityContainer.getEntity()).getRuleSet() == null) continue;
            GdsTripartiteHelper.mergeResults(GdsTripartiteHelper.getCodes(((TripartiteContract)entityContainer.getEntity()).getRuleSet(), gdsAccountCtr, () -> GdsTripartiteHelper.getCarriers((TripartiteContract)contract.getEntity()), action), result);
        }
        for (EntityContainer<TripartiteContract> entityContainer : IBusGdsHelper.collectContracts(salesContext, agencies)) {
            if (((Contract)entityContainer.getEntity()).getRuleSet() == null) continue;
            GdsTripartiteHelper.mergeResults(GdsTripartiteHelper.getCodes(((Contract)entityContainer.getEntity()).getRuleSet(), gdsAccountCtr, () -> GdsTripartiteHelper.getCarriers((Contract)contract.getEntity()), action), result);
        }
        return result;
    }

    private static Set<DictionaryReference<Airline>> getCarriers(TripartiteContract tripartiteContract) {
        return Stream.concat(tripartiteContract.getAviaVendorData().getAirlines().stream(), tripartiteContract.getAviaVendorData().getAlliances().stream().map(DictHelper::findAirlinesByAlliance).flatMap(Collection::stream).map(Airline::toReference)).collect(Collectors.toSet());
    }

    private static Set<DictionaryReference<Airline>> getCarriers(Contract contract) {
        return Collections.singleton(((Organization)EntityStorage.get().resolve(contract.getSupplier()).getEntity()).getAirline());
    }

    private static Map<DictionaryReference<Airline>, Collection<String>> getCodes(RuleSet ruleSet, final EntityContainer<BaseGdsAccount> gdsAccountCtr, Supplier<Set<DictionaryReference<Airline>>> carriersSupplier, RuleAction action) {
        HashMap airlinesCache = new HashMap();
        HashMap<DictionaryReference<Airline>, Collection<String>> result = new HashMap<DictionaryReference<Airline>, Collection<String>>();
        block0: for (RuleSettings rs : ruleSet.getRules()) {
            if (rs.getPeriodBegin() != null && rs.getPeriodBegin().after(new Date()) || rs.getPeriodEnd() != null && rs.getPeriodEnd().before(new Date())) continue;
            Collection carrierCodes = null;
            for (RuleRestriction rr : rs.getRestrictions()) {
                if (rr.getProperty() == Properties.GDS_NAME) {
                    if (rr.getProperty().match(() -> ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds().name(), rr.getCondition(), rr.getValue())) continue;
                    continue block0;
                }
                if (rr.getProperty() == com.gridnine.xtrip.common.gds.rules.Properties.GDS_ACCOUNT) {
                    if (rr.getProperty().match((Object)new GdsPropertiesProvider(){

                        public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
                            return gdsAccountCtr.toReference();
                        }

                        public String getGdsName() {
                            return ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds().name();
                        }
                    }, rr.getCondition(), rr.getValue())) continue;
                    continue block0;
                }
                if (rr.getProperty() != Properties.CARRIERS || rr.getCondition() != Conditions.INCLUDE && rr.getCondition() != Conditions.CONTAINS_ONLY) continue;
                carrierCodes = RulesHelper.toStringCollection((Object)rr.getValue());
            }
            Set<DictionaryReference<Airline>> carriers = carrierCodes == null ? carriersSupplier.get() : carrierCodes.stream().map(code -> airlinesCache.computeIfAbsent(code, DictHelper::findAirlineByAnyCode)).filter(Objects::nonNull).map(Airline::toReference).collect(Collectors.toSet());
            for (RuleResult rr : rs.getResults()) {
                if (rr.getAction() != action) continue;
                for (DictionaryReference<Airline> carrier : carriers) {
                    result.computeIfAbsent(carrier, k -> new HashSet()).addAll(RulesHelper.toStringCollection((Object)rr.getValue()));
                }
            }
        }
        return result;
    }

    private static void mergeResults(Map<DictionaryReference<Airline>, Collection<String>> newPortion, Map<DictionaryReference<Airline>, Collection<String>> destination) {
        for (Map.Entry<DictionaryReference<Airline>, Collection<String>> newEntry : newPortion.entrySet()) {
            if (destination.containsKey(newEntry.getKey())) {
                destination.get(newEntry.getKey()).addAll(newEntry.getValue());
                continue;
            }
            destination.put(newEntry.getKey(), newEntry.getValue());
        }
    }
}

