/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.server.gds.ibus.GdsTripartiteHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class GetAccountCodesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityReference[] agencies = (EntityReference[])ctx.getMandatoryObject((Enum)IBusGdsContextKeys.AGENCIES_FOR_TRIPARTITE);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Collection airlines = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.AIRLINES_FOR_TRIPARTITE_CONTRACTS);
        Map<DictionaryReference<Airline>, Collection<String>> accountCodes = GdsTripartiteHelper.getCodes(salesContext, (EntityContainer<BaseGdsAccount>)gdsAccountCtr, airlines, agencies, (RuleAction)AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE);
        ctx.putObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE, accountCodes);
        ctx.putObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES, accountCodes.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
    }
}

