/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashSet;

public class GetApplicableAirlinesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Collection<DictionaryReference<Airline>> airlines = this.getApplicableAirlines(fsp, gdsParameters, ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds());
        ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_AIRLINES, airlines);
    }

    private Collection<DictionaryReference<Airline>> getApplicableAirlines(FlightSearchParameters fsp, GDSParameters gdsParameters, GdsName gds) {
        HashSet<DictionaryReference<Airline>> result = new HashSet<DictionaryReference<Airline>>();
        if (!fsp.getPreferredAirlines().isEmpty()) {
            for (DictionaryReference airlineRef : fsp.getPreferredAirlines()) {
                if (!gdsParameters.getPreferredAirlines().contains(airlineRef) && !gdsParameters.getPreferredAirlines().isEmpty()) continue;
                result.add((DictionaryReference<Airline>)airlineRef);
            }
            if (result.isEmpty()) {
                throw Xeption.forAdmin((String)"\u041d\u0438 \u043e\u0434\u043d\u0430 \u0438\u0437 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439 \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430 \u043a \u043f\u043e\u0438\u0441\u043a\u0443 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0}", (Object[])new Object[]{gds});
            }
        } else {
            result.addAll(gdsParameters.getPreferredAirlines());
        }
        return result;
    }
}

