/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.GetBlankOwnersRequest;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;

public class GetBlankOwnersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetBlankOwnersRequest request = (GetBlankOwnersRequest)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GET_BLANK_OWNERS_REQUEST);
        Locale locale = LocaleManager.get().getCurrentLocale();
        int limit = 0;
        if (request.getLimit() != null) {
            if (request.getLimit() <= 0) {
                throw Xeption.forDeveloper((String)"limit <= 0", (Object[])new Object[0]);
            }
            if (request.getLimit() > 100) {
                throw Xeption.forDeveloper((String)"limit > 100", (Object[])new Object[0]);
            }
            limit = request.getLimit();
        }
        ArrayList<BaseEntity> organizations = new ArrayList<BaseEntity>();
        ArrayList<EntityReference> organizationReferences = new ArrayList<EntityReference>();
        ArrayList<Object> searchResult = new ArrayList<Object>();
        ArrayList searchResultIndices = new ArrayList();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER.name()));
        query = this.modifyQuery(query, ctx);
        if (request.getPattern() == null) {
            searchResultIndices.addAll(EntityStorage.get().search(OrganizationIndex.class, query).getData());
        } else {
            String pattern = request.getPattern();
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ilike((String)OrganizationIndex.Property.code.name(), (String)pattern), SearchCriterion.ilike((String)OrganizationIndex.Property.shortName.name(), (String)("%" + pattern + "%")), SearchCriterion.ilike((String)OrganizationIndex.Property.name.name(), (String)("%" + pattern + "%"))}));
            searchResultIndices.addAll(EntityStorage.get().search(OrganizationIndex.class, query).getData());
        }
        for (OrganizationIndex organizationIndex : searchResultIndices) {
            EntityContainer orgCont = EntityStorage.get().resolve(organizationIndex.getSource());
            if (EntityStorageHelper.isEmpty((EntityContainer)orgCont)) continue;
            searchResult.add(orgCont);
        }
        searchResult.sort(this.createBlankOwnersComparator(request.getPattern(), locale));
        for (EntityContainer entityContainer : searchResult) {
            organizations.add(entityContainer.getEntity());
            organizationReferences.add(entityContainer.toReference());
            if (organizations.size() != limit) continue;
            break;
        }
        ctx.putObject((Enum)IBusGdsContextKeys.GET_BLANK_OWNERS_RESPONSE, organizations);
        ctx.putObject((Enum)IBusGdsContextKeys.GET_BLANK_OWNERS_REFERENCES_RESPONSE, organizationReferences);
    }

    private Comparator<EntityContainer<Organization>> createBlankOwnersComparator(String pattern, Locale locale) {
        return (o1, o2) -> GetBlankOwnersProcessor.compareOrganizations((EntityContainer<Organization>)o1, (EntityContainer<Organization>)o2, pattern, locale);
    }

    private static int compareOrganizations(EntityContainer<Organization> orgCont1, EntityContainer<Organization> orgCont2, String pattern, Locale locale) {
        Organization o1 = (Organization)orgCont1.getEntity();
        Organization o2 = (Organization)orgCont2.getEntity();
        int result = 0;
        if (pattern != null) {
            result = MiscUtil.compare((int)GetBlankOwnersProcessor.getPatternPosition(o1, pattern, locale), (int)GetBlankOwnersProcessor.getPatternPosition(o2, pattern, locale));
        }
        if (result == 0) {
            result = MiscUtil.compare((Comparable)((Comparable)MiscUtil.findByLocale((Map)o1.getShortName().getValues(), (Locale)locale)), (Comparable)((Comparable)MiscUtil.findByLocale((Map)o2.getShortName().getValues(), (Locale)locale)));
        }
        return result;
    }

    private static int getPatternPosition(Organization org, String pattern, Locale locale) {
        String name = (String)MiscUtil.findByLocale((Map)org.getShortName().getValues(), (Locale)locale);
        int result = name.indexOf(pattern);
        if (result == -1) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    protected SearchQuery modifyQuery(SearchQuery query, MessageContext ctx) throws Exception {
        return query;
    }
}

