/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.GdsCapabilities;
import com.gridnine.xtrip.common.gds.model.SaveFareRulesOperation;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class GetGdsCapabilitiesProcessor
extends BaseProcessor {
    private boolean fqtvBookingSupported;
    private boolean fqtvAddSupported;
    private boolean fqtvUpdateSupported;
    private boolean fqtvDeleteSupported;
    private boolean docoDocaDuringBookingSupported;
    private boolean docoDocaAfterBookingSupported;
    private boolean ancillaryFeesForBookingSupported;
    private boolean cityFilterSupported;
    private boolean youthPassengerTypeSupported;
    private boolean seniorPassengerTypeSupported;
    private boolean infantWithSitePassengerTypeSupported;
    private boolean agedChildrenPassengerTypesSupported;
    private boolean voidSupported;
    private boolean voidWithMcoSupported;
    private String saveFareRulesOperation;
    private boolean searchRouteSegmentAirlineSupported;
    private boolean searchRouteSegmentFlightNumberSupported;
    private boolean standaloneSearchFlightFaresSupported;

    public void configure(Map<String, String> parameters) {
        this.fqtvBookingSupported = MiscUtil.isTrue((String)parameters.get("fqtv-booking-supported"));
        this.fqtvAddSupported = MiscUtil.isTrue((String)parameters.get("fqtv-add-supported"));
        this.fqtvUpdateSupported = MiscUtil.isTrue((String)parameters.get("fqtv-update-supported"));
        this.fqtvDeleteSupported = MiscUtil.isTrue((String)parameters.get("fqtv-delete-supported"));
        this.docoDocaDuringBookingSupported = MiscUtil.isTrue((String)parameters.get("doco-doca-during-booking-supported"));
        this.docoDocaAfterBookingSupported = MiscUtil.isTrue((String)parameters.get("doco-doca-after-booking-supported"));
        this.ancillaryFeesForBookingSupported = MiscUtil.isTrue((String)parameters.get("ancillary-fees-for-booking-supported"));
        this.cityFilterSupported = MiscUtil.isTrue((String)parameters.get("city-filter-supported"));
        this.youthPassengerTypeSupported = MiscUtil.isTrue((String)parameters.get("youth-passenger-type-supported"));
        this.seniorPassengerTypeSupported = MiscUtil.isTrue((String)parameters.get("senior-passenger-type-supported"));
        this.infantWithSitePassengerTypeSupported = MiscUtil.isTrue((String)parameters.get("infant-with-site-passenger-type-supported"));
        this.agedChildrenPassengerTypesSupported = MiscUtil.isTrue((String)parameters.get("aged-children-passenger-types-supported"));
        this.voidSupported = MiscUtil.isTrue((String)parameters.get("void-supported"));
        this.voidWithMcoSupported = MiscUtil.isTrue((String)parameters.get("void-with-mco-supported"));
        this.saveFareRulesOperation = parameters.get("save-fare-rules-operation");
        this.searchRouteSegmentAirlineSupported = MiscUtil.isTrue((String)parameters.get("search-route-segment-airline-supported"));
        this.searchRouteSegmentFlightNumberSupported = MiscUtil.isTrue((String)parameters.get("search-route-segment-flight-number-supported"));
        this.standaloneSearchFlightFaresSupported = MiscUtil.isTrue((String)parameters.get("standalone-search-flight-fares-supported"));
    }

    public void process(MessageContext ctx) {
        GdsCapabilities c = new GdsCapabilities();
        c.setFqtvBookingSupported(this.fqtvBookingSupported);
        c.setFqtvAddSupported(this.fqtvAddSupported);
        c.setFqtvUpdateSupported(this.fqtvUpdateSupported);
        c.setFqtvDeleteSupported(this.fqtvDeleteSupported);
        c.setDocoDocaDuringBookingSupported(this.docoDocaDuringBookingSupported);
        c.setDocoDocaAfterBookingSupported(this.docoDocaAfterBookingSupported);
        c.setAncillaryFeesForBookingSupported(this.ancillaryFeesForBookingSupported);
        c.setCityFilterSupported(this.cityFilterSupported);
        c.setYouthPassengerTypeSupported(this.youthPassengerTypeSupported);
        c.setSeniorPassengerTypeSupported(this.seniorPassengerTypeSupported);
        c.setInfantWithSitePassengerTypeSupported(this.infantWithSitePassengerTypeSupported);
        c.setAgedChildrenPassengerTypesSupported(this.agedChildrenPassengerTypesSupported);
        c.setVoidSupported(this.voidSupported);
        c.setVoidWithMcoSupported(this.voidWithMcoSupported);
        c.setSaveFareRulesOperation(this.saveFareRulesOperation == null ? SaveFareRulesOperation.TICKET_RESERVATION : SaveFareRulesOperation.valueOf((String)this.saveFareRulesOperation));
        c.setSearchRouteSegmentAirlineSupported(this.searchRouteSegmentAirlineSupported);
        c.setSearchRouteSegmentFlightNumberSupported(this.searchRouteSegmentFlightNumberSupported);
        c.setStandaloneSearchFlightFaresSupported(this.standaloneSearchFlightFaresSupported);
        ctx.putObject((Enum)IBusGdsContextKeys.GDS_CAPABILITIES, (Object)c);
    }
}

