/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Hours;
import org.joda.time.ReadableInstant;

public class GetRefundStatusProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Date now = new Date();
        int voidCnt = 0;
        int refundCnt = 0;
        for (BaseProduct bp : reservation.getProducts()) {
            ProductHandler handler = HandlersRegistry.get().findProductHandler(bp.getClass());
            Date firstTravelDate = handler.findFirstTravelDate(bp);
            if (!MiscUtil.isSameDay((Date)now, (Date)firstTravelDate) && MiscUtil.isSameDay((Date)handler.findIssueDate(bp), (Date)now) && Hours.hoursBetween((ReadableInstant)new DateTime((Object)now), (ReadableInstant)new DateTime((Object)firstTravelDate)).getHours() >= 24) {
                ++voidCnt;
                continue;
            }
            ++refundCnt;
        }
        if (voidCnt > 0) {
            if (refundCnt > 0) {
                throw Xeption.forDeveloper((String)"mixed refund mode detected", (Object[])new Object[0]);
            }
            ctx.putObject((Enum)IBusMidofficeContextKeys.REFUND_TICKETS_STATUS, (Object)"VOID");
        } else {
            if (refundCnt == 0) {
                throw Xeption.forDeveloper((String)"no tickets found to refund", (Object[])new Object[0]);
            }
            ctx.putObject((Enum)IBusMidofficeContextKeys.REFUND_TICKETS_STATUS, (Object)"REFUND");
        }
    }
}

