/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Map;

public class HasMcoProductProvider
extends BaseRoutingKeyProvider {
    private boolean fromBaseProducts = false;
    public ProductStatus status = null;
    public MCOCategory mcoCategory;

    public void configure(Map<String, String> parameters) {
        String mc;
        this.fromBaseProducts = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(parameters, (String)"fromBaseProducts", (String)"false"));
        String checkStatusParameter = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"status", null);
        if (checkStatusParameter != null) {
            this.status = ProductStatus.valueOf((String)checkStatusParameter);
        }
        if ((mc = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"mcoCategory")) != null) {
            this.mcoCategory = MCOCategory.valueOf((String)mc);
        }
    }

    public String getRoutingKey(MessageContext ctx) throws Exception {
        boolean hasMco;
        if (this.fromBaseProducts) {
            Collection baseProducts = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
            hasMco = GDSHelper.getMcoProductsStream(baseProducts).anyMatch(mco -> this.status == null || this.status == mco.getStatus());
        } else {
            Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
            hasMco = GDSHelper.getMcoProductsStream(reservation.getProducts()).filter(mco -> this.status == null || this.status == mco.getStatus()).anyMatch(mco -> this.mcoCategory == null || this.mcoCategory == mco.getMcoCategory());
        }
        return Boolean.toString(hasMco);
    }
}

