/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractCustomerInfo;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBusGdsHelper {
    private static final Logger log = LoggerFactory.getLogger(IBusGdsHelper.class);

    public static GdsTracingItemBuilder getGdsTracingItemBuilder(MessageContext ctx) {
        GdsTracingItemBuilder builder = null;
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        if (gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveSearchTraces()) {
            builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        }
        return builder;
    }

    public static List<SeatPreferences> getSeats(MessageContext ctx) {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        if (fsp != null) {
            return fsp.getSeats();
        }
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        return flight.getSeats();
    }

    public static List<EntityContainer<TripartiteContract>> collectTripartiteContracts(SalesContext salesContext, Collection<DictionaryReference<Airline>> airlines, EntityReference[] agencies) {
        ArrayList<EntityContainer<TripartiteContract>> contracts = new ArrayList<EntityContainer<TripartiteContract>>();
        EntityReference clientRef = SalesContextHandler.get().getClient(salesContext);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.contractType.name(), (Object)TripartiteContractType.AVIA));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)TripartiteContractIndex.Property.agency.name(), (Object[])agencies));
        if (SalesContextHandler.get().getAllClients() == null) {
            log.debug("profile 'all clients' not set");
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)clientRef.getUid()));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)clientRef.getUid()), SearchCriterion.contains((String)TripartiteContractIndex.Property.customerUids.name(), (Object)SalesContextHandler.get().getAllClients().getUid())}));
        }
        List indexes = EntityStorage.get().search(TripartiteContractIndex.class, query).getData();
        block0: for (TripartiteContractIndex index : indexes) {
            log.debug(String.format("check if contract '%s' is applicable for current search parameters", index.getSource()));
            boolean include = airlines.isEmpty();
            log.debug(String.format("airlines being searched for: %s", CollectionUtil.collectionToString(airlines, (String)",", (boolean)false)));
            if (!include) {
                for (DictionaryReference airlineRef : index.getVendorAirlines()) {
                    log.debug(String.format("check if airline '%s' from contract is being searched for", airlineRef));
                    if (airlines.contains(airlineRef)) {
                        log.debug(String.format("airline '%s' from contract is being searched for", airlineRef));
                        include = true;
                        break;
                    }
                    log.debug(String.format("airline '%s' from contract is not being searched for", airlineRef));
                }
            }
            if (!include) {
                block2: for (DictionaryReference allianceRef : index.getVendorAlliances()) {
                    log.debug(String.format("check if one of airlines from '%s' alliance from contract is being searched for", allianceRef));
                    for (Airline airline : DictHelper.findAirlinesByAlliance((DictionaryReference)allianceRef)) {
                        AirlineReference airlineRef = airline.toReference();
                        log.debug(String.format("check if airline '%s' from alliance '%s' from contract is being searched for", airlineRef, allianceRef));
                        if (airlines.contains(airlineRef)) {
                            log.debug(String.format("airline '%s' from alliance '%s' from contract is being searched for", airlineRef, allianceRef));
                            include = true;
                            break block2;
                        }
                        log.debug(String.format("airline '%s' from alliance '%s' from contract is not being searched for", airlineRef, allianceRef));
                    }
                }
            }
            if (!include) {
                log.debug(String.format("contract '%s' is not applicable for current search parameters", index.getSource()));
                continue;
            }
            log.debug(String.format("contract '%s' is applicable for current search parameters", index.getSource()));
            EntityContainer ctr = EntityStorage.get().resolve(index.getSource());
            for (TripartiteContractCustomerInfo info : ((TripartiteContract)ctr.getEntity()).getCustomers()) {
                if (!clientRef.equals((Object)info.getCustomer())) continue;
                if (!IBusGdsHelper.isAppropriateDate(info)) continue block0;
                contracts.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(index.getSource()));
                continue block0;
            }
            if (SalesContextHandler.get().getAllClients() == null) continue;
            for (TripartiteContractCustomerInfo info : ((TripartiteContract)ctr.getEntity()).getCustomers()) {
                if (!SalesContextHandler.get().getAllClients().equals((Object)info.getCustomer())) continue;
                if (!IBusGdsHelper.isAppropriateDate(info)) continue block0;
                contracts.add((EntityContainer<TripartiteContract>)EntityStorage.get().resolve(index.getSource()));
                continue block0;
            }
        }
        contracts.sort((o1, o2) -> MiscUtil.compare((Date)IBusGdsHelper.findIssueDate((EntityContainer<TripartiteContract>)o1, (EntityReference<Organization>)clientRef), (Date)IBusGdsHelper.findIssueDate((EntityContainer<TripartiteContract>)o2, (EntityReference<Organization>)clientRef), (boolean)false));
        return contracts;
    }

    public static List<EntityContainer<Contract>> collectContracts(SalesContext salesContext, EntityReference[] agencies) {
        List<EntityContainer<Contract>> result = IBusGdsHelper.collectNewContract(salesContext, agencies);
        if (!result.isEmpty()) {
            return result;
        }
        return IBusGdsHelper.collectOldContracts(salesContext, agencies);
    }

    private static List<EntityContainer<Contract>> collectNewContract(SalesContext salesContext, EntityReference[] agencies) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)ContractIndex.Property.customer.name(), (Object[])agencies));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.contractType.name(), (Object)ContractType.VENDOR));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)new Date()))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)new Date()))}));
        ArrayList contractIndexes = new ArrayList(EntityStorage.get().search(ContractIndex.class, query).getData());
        contractIndexes.sort((o1, o2) -> {
            if (o1.isDefaultContract() != o2.isDefaultContract()) {
                return o1.isDefaultContract() ? -1 : 1;
            }
            return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
        });
        return contractIndexes.stream().map(i -> EntityStorage.get().resolve(i.getSource())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<EntityContainer<Contract>> collectOldContracts(SalesContext salesContext, EntityReference[] agencies) {
        EntityReference allAgenciesProfile = ProfileDao.findAllAgenciesProfile();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null)}));
        SearchCriterion hCustCrit = SearchCriterion.in((String)ContractCustomerIndex.Property.customer.name(), (Object[])agencies);
        if (allAgenciesProfile == null) {
            query.getCriteria().getCriterions().add(hCustCrit);
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{hCustCrit, SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)allAgenciesProfile)}));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.VENDOR));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)new Date()))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)new Date()))}));
        ArrayList<EntityContainer<Contract>> contracts = new ArrayList<EntityContainer<Contract>>();
        HashMap<EntityReference, EntityContainer> contractsMap = new HashMap<EntityReference, EntityContainer>();
        ArrayList contractIndexes = new ArrayList(EntityStorage.get().search(ContractCustomerIndex.class, query).getData());
        for (ContractCustomerIndex item : contractIndexes) {
            contractsMap.put(item.getSource(), EntityStorage.get().resolve(item.getSource()));
        }
        contractIndexes.sort((o1, o2) -> {
            int index2;
            EntityContainer ctr1 = (EntityContainer)contractsMap.get(o1.getSource());
            EntityContainer ctr2 = (EntityContainer)contractsMap.get(o2.getSource());
            if (((Contract)ctr1.getEntity()).getPriority() != ((Contract)ctr2.getEntity()).getPriority()) {
                return ((Contract)ctr1.getEntity()).getPriority() > ((Contract)ctr2.getEntity()).getPriority() ? -1 : 1;
            }
            int index1 = IBusGdsHelper.getGeneralityIndex(o1, (EntityReference<Organization>)allAgenciesProfile);
            if (index1 != (index2 = IBusGdsHelper.getGeneralityIndex(o2, (EntityReference<Organization>)allAgenciesProfile))) {
                return index1 > index2 ? 1 : -1;
            }
            if (((Contract)ctr1.getEntity()).isTypicalContract() != ((Contract)ctr2.getEntity()).isTypicalContract()) {
                return ((Contract)ctr1.getEntity()).isTypicalContract() ? 1 : -1;
            }
            return -MiscUtil.compare((Date)o1.getIssueDate(), (Date)o2.getIssueDate(), (boolean)true);
        });
        for (ContractCustomerIndex index : contractIndexes) {
            EntityContainer ctr = (EntityContainer)contractsMap.get(index.getSource());
            if (contracts.contains(ctr)) continue;
            contracts.add((EntityContainer<Contract>)ctr);
        }
        return contracts;
    }

    private static int getGeneralityIndex(ContractCustomerIndex cci, EntityReference<Organization> allAgenciesProfile) {
        return (allAgenciesProfile != null && allAgenciesProfile.equals((Object)cci.getSupplier()) ? 4 : 0) + (allAgenciesProfile != null && allAgenciesProfile.equals((Object)cci.getCustomer()) ? 2 : 0);
    }

    private static boolean isAppropriateDate(TripartiteContractCustomerInfo info) {
        Date now = new Date();
        return !(info.getStartDate() != null && !info.getStartDate().before(now) || info.getEndDate() != null && !info.getEndDate().after(now));
    }

    private static Date findIssueDate(EntityContainer<TripartiteContract> contractCtr, EntityReference<Organization> clientRef) {
        for (TripartiteContractCustomerInfo info : ((TripartiteContract)contractCtr.getEntity()).getCustomers()) {
            if (!clientRef.equals((Object)info.getCustomer()) || info.getIssueDate() == null) continue;
            return info.getIssueDate();
        }
        if (SalesContextHandler.get().getAllClients() != null) {
            for (TripartiteContractCustomerInfo info : ((TripartiteContract)contractCtr.getEntity()).getCustomers()) {
                if (!SalesContextHandler.get().getAllClients().equals((Object)info.getCustomer()) || info.getIssueDate() == null) continue;
                return info.getIssueDate();
            }
        }
        return null;
    }

    public static StringBuilder getNewPattern(String oldPattern) throws Exception {
        String CHARS_FROM = "qwertyuiop[]asdfghjkl;'zxcvbnm,.`QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>~\u0439\u0446\u0443\u043a\u0435\u043d\u0433\u0448\u0449\u0437\u0444\u044b\u0432\u0430\u043f\u0440\u043e\u043b\u0434\u044f\u0447\u0441\u043c\u0438\u0442\u044c\u0419\u0426\u0423\u041a\u0415\u041d\u0413\u0428\u0429\u0417\u0424\u042b\u0412\u0410\u041f\u0420\u041e\u041b\u0414\u042f\u0427\u0421\u041c\u0418\u0422\u042c";
        String CHARS_TO = "\u0439\u0446\u0443\u043a\u0435\u043d\u0433\u0448\u0449\u0437\u0445\u044a\u0444\u044b\u0432\u0430\u043f\u0440\u043e\u043b\u0434\u0436\u044d\u044f\u0447\u0441\u043c\u0438\u0442\u044c\u0431\u044e\u0451\u0419\u0426\u0423\u041a\u0415\u041d\u0413\u0428\u0429\u0417\u0425\u042a\u0424\u042b\u0412\u0410\u041f\u0420\u041e\u041b\u0414\u0416\u042d\u042f\u0427\u0421\u041c\u0418\u0422\u042c\u0411\u042e\u0401qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
        StringBuilder newPattern = new StringBuilder();
        for (int i = 0; i < oldPattern.length(); ++i) {
            char c = oldPattern.charAt(i);
            int idx = "qwertyuiop[]asdfghjkl;'zxcvbnm,.`QWERTYUIOP{}ASDFGHJKL:\"ZXCVBNM<>~\u0439\u0446\u0443\u043a\u0435\u043d\u0433\u0448\u0449\u0437\u0444\u044b\u0432\u0430\u043f\u0440\u043e\u043b\u0434\u044f\u0447\u0441\u043c\u0438\u0442\u044c\u0419\u0426\u0423\u041a\u0415\u041d\u0413\u0428\u0429\u0417\u0424\u042b\u0412\u0410\u041f\u0420\u041e\u041b\u0414\u042f\u0427\u0421\u041c\u0418\u0422\u042c".indexOf(c);
            if (idx == -1) {
                newPattern.append(c);
                continue;
            }
            newPattern.append("\u0439\u0446\u0443\u043a\u0435\u043d\u0433\u0448\u0449\u0437\u0445\u044a\u0444\u044b\u0432\u0430\u043f\u0440\u043e\u043b\u0434\u0436\u044d\u044f\u0447\u0441\u043c\u0438\u0442\u044c\u0431\u044e\u0451\u0419\u0426\u0423\u041a\u0415\u041d\u0413\u0428\u0429\u0417\u0425\u042a\u0424\u042b\u0412\u0410\u041f\u0420\u041e\u041b\u0414\u0416\u042d\u042f\u0427\u0421\u041c\u0418\u0422\u042c\u0411\u042e\u0401qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM".charAt(idx));
        }
        return newPattern;
    }
}

