/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.model.booking.TimeLimitType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.rules.proxy.GDSParametersActions;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.StringUtils;

public class PopulateGdsParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GDSParametersActions actions = (GDSParametersActions)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS_ACTIONS);
        GDSParameters gdsParameters = (GDSParameters)ctx.getObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        if (gdsParameters == null) {
            gdsParameters = new GDSParameters();
            ctx.putObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS, (Object)gdsParameters);
        }
        this.populateGdsParameters(gdsParameters, actions);
        if (actions.getUsedGdsAccount() != null) {
            ctx.putObject((Enum)IBusGdsContextKeys.USED_GDS_ACCOUNT, actions.getUsedGdsAccount());
        }
    }

    private void populateGdsParameters(GDSParameters parameters, GDSParametersActions actions) {
        TimeLimitType timeLimitType;
        if (!StringUtils.isBlank((String)actions.getSearchPCC()) || actions.getSearchPCCRef() != null) {
            PccHelper.setSearchPcc((GDSParameters)parameters, (String)actions.getSearchPCC(), actions.getSearchPCCRef());
        }
        if (!StringUtils.isBlank((String)actions.getBookingPCC()) || actions.getBookingPCCRef() != null) {
            PccHelper.setBookingPcc((GDSParameters)parameters, (String)actions.getBookingPCC(), actions.getBookingPCCRef());
        }
        if (!StringUtils.isBlank((String)actions.getTicketingPCC()) || actions.getTicketingPCCRef() != null) {
            PccHelper.setTicketingPcc((GDSParameters)parameters, (String)actions.getTicketingPCC(), actions.getTicketingPCCRef());
        }
        if (actions.getValidatingCarrier() != null) {
            parameters.setValidatingCarrier(actions.getValidatingCarrier());
        }
        if (actions.getBlankOwner() != null) {
            parameters.setBlankOwner(actions.getBlankOwner());
        }
        parameters.setSabrePrinterType(actions.getSabrePrinterType());
        parameters.setEndorsement(actions.getEndorsement());
        parameters.getRemark().addAll(actions.getRemarks());
        parameters.getPreferredAirlines().addAll(actions.getPreferredAirlines());
        if (!StringUtils.isBlank((String)actions.getFopReplacementCode())) {
            parameters.setFopReplacementCode(actions.getFopReplacementCode());
        }
        if (actions.getCharterGdsAccount() != null) {
            parameters.setCharterGdsAccount(actions.getCharterGdsAccount());
        }
        if (actions.getSabreEmulatorGdsAccount() != null) {
            parameters.setSabreEmulatorGdsAccount(actions.getSabreEmulatorGdsAccount());
        }
        if ((timeLimitType = actions.getTimeLimitType()) != null) {
            parameters.setTimeLimitType(timeLimitType);
        }
        parameters.setTimeForTimeLimit(actions.getTimeForTimeLimit());
        parameters.getWarningAboutExpiringTime().clear();
        parameters.getWarningAboutExpiringTime().addAll(actions.getWarningAboutExpiringTime());
    }
}

