/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReservationMcoProductsTargetProvider
extends BaseTargetsProvider<Product> {
    private Set<MCOCategory> mcoCategories;

    public void configure(Map<String, String> parameters) {
        String categories = IbusConfigurationHelper.getOptionalParameter(parameters, (String)"mcoCategories");
        if (categories != null) {
            this.mcoCategories = Arrays.stream(categories.split(",")).map(category -> MCOCategory.valueOf((String)category)).collect(Collectors.toSet());
        }
    }

    public Collection<Product> getTargets(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List<Product> mcoProducts = GDSHelper.getMcoProducts(reservation);
        if (this.mcoCategories == null) {
            return mcoProducts;
        }
        return mcoProducts.stream().filter(prod -> this.mcoCategories.contains(prod.getMcoCategory())).collect(Collectors.toList());
    }
}

