/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;

public class ReservationProductsForVoidProvider
extends BaseTargetsProvider<Product> {
    public Collection<Product> getTargets(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ArrayList<Product> result = new ArrayList<Product>();
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        for (BaseProduct bp : reservation.getProducts()) {
            if (!(bp instanceof Product)) {
                throw Xeption.forDeveloper((String)"{0} in reservation {1}", (Object[])new Object[]{bp.getClass().getName(), recordLocator});
            }
            Product prod = (Product)bp;
            if (prod.getProductCategory() != ProductCategory.AIR) {
                throw Xeption.forDeveloper((String)"product {0} has category {1} in reservation {2}", (Object[])new Object[]{prod.getUid(), prod.getProductCategory(), recordLocator});
            }
            if (prod.getStatus() != ProductStatus.SELL || prod.getNextProduct() != null) continue;
            result.add(prod);
        }
        if (result.isEmpty()) {
            throw Xeption.forDeveloper((String)"no products to void in reservation {0}", (Object[])new Object[]{recordLocator});
        }
        return result;
    }
}

