/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RetainRequestedRouteAdvice
extends BaseAdvice {
    public void before(MessageContext ctx) throws Exception {
        List requestedRoute;
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        if (fsp != null) {
            requestedRoute = fsp.getRoute();
        } else {
            Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
            requestedRoute = flight.getRequestedRoute();
        }
        ctx.putObject((Enum)IBusGdsContextKeys.REQUESTED_ROUTE, Collections.unmodifiableList(requestedRoute));
    }

    public void after(MessageContext ctx) throws Exception {
        Flight flight;
        List requestedRoute = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.REQUESTED_ROUTE);
        Collection flights = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (flights != null) {
            flights.forEach(f -> RetainRequestedRouteAdvice.setRequestRoute(f, requestedRoute));
        }
        if ((flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT)) != null) {
            RetainRequestedRouteAdvice.setRequestRoute(flight, requestedRoute);
        }
    }

    private static void setRequestRoute(Flight flight, List<RouteSegment> requestedRoute) {
        flight.getRequestedRoute().clear();
        flight.getRequestedRoute().addAll(requestedRoute);
    }
}

