/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SearchFlightFaresComplementOriginalFlightAdvice
extends BaseAdvice {
    private static final String KEY = "SearchFlightFaresComplementOriginalFlightAdvice.FLIGHT";

    public void before(MessageContext ctx) throws Exception {
        ctx.putObject(KEY, ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT));
    }

    public void after(MessageContext ctx) throws Exception {
        Flight originalFlight = (Flight)ctx.removeObject(KEY);
        if (originalFlight == null) {
            return;
        }
        Map<DictionaryReference<PassengerType>, List<String>> originalFareBasisData = SearchFlightFaresComplementOriginalFlightAdvice.getFareBasisData(originalFlight);
        Map<DictionaryReference<PassengerType>, List<FareInfo>> originalFareInfos = SearchFlightFaresComplementOriginalFlightAdvice.getFareInfos(originalFlight);
        Collection flights = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (flights == null) {
            return;
        }
        for (Flight flight : flights) {
            Map<DictionaryReference<PassengerType>, List<String>> fareBasisData = SearchFlightFaresComplementOriginalFlightAdvice.getFareBasisData(flight);
            List flightSegments = FlightHelper.getSegments((Flight)flight);
            for (int i = 0; i < flightSegments.size(); ++i) {
                FlightSegment fs = (FlightSegment)flightSegments.get(i);
                for (FareInfo fi : fs.getFareInfos()) {
                    if (!fareBasisData.get(fi.getPassengerType()).equals(originalFareBasisData.get(fi.getPassengerType()))) continue;
                    FareInfo originalFareInfo = originalFareInfos.get(fi.getPassengerType()).get(i);
                    if (Optional.ofNullable(fi.getFareDetails()).map(FareDetails::getCabinLuggageInfo).isPresent() || !Optional.ofNullable(originalFareInfo.getFareDetails()).map(FareDetails::getCabinLuggageInfo).isPresent()) continue;
                    if (fi.getFareDetails() == null) {
                        fi.setFareDetails(new FareDetails());
                    }
                    fi.getFareDetails().setCabinLuggageInfo((ExtendedLuggageInfo)XCloneHelper.clone((XCloneable)originalFareInfo.getFareDetails().getCabinLuggageInfo()));
                }
            }
        }
    }

    private static Map<DictionaryReference<PassengerType>, List<String>> getFareBasisData(Flight flight) {
        HashMap<DictionaryReference<PassengerType>, List<String>> result = new HashMap<DictionaryReference<PassengerType>, List<String>>();
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            for (FareInfo fi : fs.getFareInfos()) {
                List fareBasises = result.computeIfAbsent((DictionaryReference<PassengerType>)fi.getPassengerType(), k -> new ArrayList());
                fareBasises.add(fi.getFareBasis());
            }
        }
        return result;
    }

    private static Map<DictionaryReference<PassengerType>, List<FareInfo>> getFareInfos(Flight flight) {
        HashMap<DictionaryReference<PassengerType>, List<FareInfo>> result = new HashMap<DictionaryReference<PassengerType>, List<FareInfo>>();
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            for (FareInfo fi : fs.getFareInfos()) {
                List fareInfos = result.computeIfAbsent((DictionaryReference<PassengerType>)fi.getPassengerType(), k -> new ArrayList());
                fareInfos.add(fi);
            }
        }
        return result;
    }
}

