/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchFlightsAirportsProvider
extends BaseTargetsProvider<Map<RouteSegment, Pair<String>>> {
    protected final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name()});

    public Collection<Map<RouteSegment, Pair<String>>> getTargets(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        ArrayList<Map<RouteSegment, Pair<String>>> result = new ArrayList<Map<RouteSegment, Pair<String>>>();
        this.buildSearchParams(fsp.getRoute(), 0, new HashMap<RouteSegment, Pair<String>>(), result);
        return result;
    }

    private void buildSearchParams(List<RouteSegment> segments, int index, HashMap<RouteSegment, Pair<String>> map, List<Map<RouteSegment, Pair<String>>> result) {
        if (index >= segments.size()) {
            result.add((Map)map.clone());
            return;
        }
        RouteSegment routeSeg = segments.get(index);
        List<String> beginCodes = null;
        for (Map.Entry<RouteSegment, Pair<String>> entry : map.entrySet()) {
            if (entry.getKey().getLocationBegin().equals((Object)routeSeg.getLocationBegin())) {
                beginCodes = new ArrayList<String>();
                beginCodes.add((String)entry.getValue().getFirst());
                break;
            }
            if (!entry.getKey().getLocationEnd().equals((Object)routeSeg.getLocationBegin())) continue;
            beginCodes = new ArrayList<String>();
            beginCodes.add((String)entry.getValue().getLast());
            break;
        }
        if (beginCodes == null) {
            beginCodes = this.findAirportsCodes((DictionaryReference<GeoLocation>)routeSeg.getLocationBegin());
        }
        List<String> endCodes = null;
        for (Map.Entry<RouteSegment, Pair<String>> entry : map.entrySet()) {
            if (entry.getKey().getLocationBegin().equals((Object)routeSeg.getLocationEnd())) {
                endCodes = new ArrayList<String>();
                endCodes.add((String)entry.getValue().getFirst());
                break;
            }
            if (!entry.getKey().getLocationEnd().equals((Object)routeSeg.getLocationEnd())) continue;
            endCodes = new ArrayList<String>();
            endCodes.add((String)entry.getValue().getLast());
            break;
        }
        if (endCodes == null) {
            endCodes = this.findAirportsCodes((DictionaryReference<GeoLocation>)routeSeg.getLocationEnd());
        }
        for (String beginCode : beginCodes) {
            for (String endCode : endCodes) {
                map.put(routeSeg, (Pair<String>)new Pair((Object)beginCode, (Object)endCode));
                this.buildSearchParams(segments, index + 1, map, result);
            }
        }
        map.remove(routeSeg);
    }

    private List<String> findAirportsCodes(DictionaryReference<GeoLocation> locRef) {
        ArrayList<String> codes = new ArrayList<String>();
        GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(locRef);
        if (loc == null) {
            codes.add(locRef.getCode());
            return codes;
        }
        List<String> customCodes = this.buildCustomCodes(locRef);
        if (customCodes.size() > 0) {
            return customCodes;
        }
        List locations = DictHelper.findAirportsByCity(locRef);
        for (DictionaryReference ref : locations) {
            codes.add(this.codeTranslator.getNativeCode(ref));
        }
        return codes;
    }

    protected List<String> buildCustomCodes(DictionaryReference<GeoLocation> locRef) {
        return Collections.emptyList();
    }
}

