/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTracingDocument;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.BooleanUtils;

public class SelectFlightSaveTraceAsTemporalObjectAdvice
extends BaseAdvice {
    private static final String DISABLE_LOG_DOCUMENT_CUSTOM_KEY = SelectFlightSaveTraceAsTemporalObjectAdvice.class.getName() + ".DISABLE_LOG_DOCUMENT";
    private static final String GDS_TRACING_SETTINGS_CUSTOM_KEY = SelectFlightSaveTraceAsTemporalObjectAdvice.class.getName() + ".GDS_TRACING_SETTINGS";

    public void before(MessageContext ctx) throws Exception {
        Boolean disableLogDocument = (Boolean)ctx.removeObject((Enum)IBusMidofficeContextKeys.DISABLE_LOG_DOCUMENT);
        ctx.putObject(DISABLE_LOG_DOCUMENT_CUSTOM_KEY, (Object)disableLogDocument);
        GdsTracingSettings actualSettings = (GdsTracingSettings)ctx.removeObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        ctx.putObject(GDS_TRACING_SETTINGS_CUSTOM_KEY, (Object)actualSettings);
        GdsTracingSettings gdsTracingSettings = actualSettings != null ? (GdsTracingSettings)XCloneHelper.clone((XCloneable)actualSettings) : new GdsTracingSettings();
        gdsTracingSettings.setActive(true);
        gdsTracingSettings.setSaveSearchTraces(true);
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS, (Object)gdsTracingSettings);
        if (!ctx.hasObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT)) {
            GdsTracingDocument document = new GdsTracingDocument();
            document.setName("select-flight");
            document.setCreated(new Date());
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT, (Object)document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(MessageContext ctx) throws Exception {
        try {
            GdsTracingDocument document = (GdsTracingDocument)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
            boolean skipSave = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT_SKIP_SAVE_AS_TEMPORAL_OBJECT)));
            if (document != null && !skipSave) {
                TemporalObject to = new TemporalObject();
                to.setData(XSUtil.toByteArray((XSSerializable)document));
                to.setTag("select-flight-trace");
                to.setExpired(new Date(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L)));
                AssetsStorage.get().save((BaseAsset)to);
                Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
                GDSHelper.setSelectFlightTraceTemporalObjectUid(flight, to.getUid());
            }
        }
        finally {
            Boolean disableLogDocument = (Boolean)ctx.removeObject(DISABLE_LOG_DOCUMENT_CUSTOM_KEY);
            ctx.putObject((Enum)IBusMidofficeContextKeys.DISABLE_LOG_DOCUMENT, (Object)disableLogDocument);
            if (Boolean.TRUE.equals(disableLogDocument)) {
                ctx.removeObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_DOCUMENT);
            }
            GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.removeObject(GDS_TRACING_SETTINGS_CUSTOM_KEY);
            ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS, (Object)gdsTracingSettings);
        }
    }
}

