/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.xtrip.common.gds.model.SimpleMatrixElement;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SimpleMatrixAggregator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map multiResult = (Map)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_MULTICALL_RESULT);
        if (multiResult == null) {
            ctx.addMessage(MessageHelper.createWarningMessage((String)"\u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0440\u0438\u043c\u0435\u043d\u0438\u043c\u044b\u0445 \u0441\u0438\u0441\u0442\u0435\u043c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0443\u0441\u0442, \u043f\u043e\u0438\u0441\u043a \u043d\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d", (Object[])new Object[0]));
            ctx.putObject((Enum)IBusGdsContextKeys.SIMPLE_MATRIX, new ArrayList());
            return;
        }
        List allElements = multiResult.values().stream().map(subCtx -> (Collection)subCtx.getObject((Enum)IBusGdsContextKeys.SIMPLE_MATRIX)).filter(CollectionUtil::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
        HashMap from = new HashMap();
        for (SimpleMatrixElement elementEx : allElements) {
            LocalDate dateFrom = elementEx.getDateFrom();
            HashMap<LocalDate, SimpleMatrixElement> to = new HashMap<LocalDate, SimpleMatrixElement>();
            for (SimpleMatrixElement elementIn : allElements) {
                LocalDate dateTo;
                if (!dateFrom.equals(elementIn.getDateFrom()) || to.containsKey(dateTo = elementIn.getDateTo()) && (!to.containsKey(dateTo) || elementIn.getBestPrice().getValue().compareTo(((SimpleMatrixElement)to.get(dateTo)).getBestPrice().getValue()) >= 0)) continue;
                to.put(dateTo, elementIn);
            }
            from.put(dateFrom, to);
        }
        List result = from.entrySet().stream().flatMap(entryEx -> ((Map)entryEx.getValue()).entrySet().stream()).map(Map.Entry::getValue).collect(Collectors.toList());
        ctx.putObject((Enum)IBusGdsContextKeys.SIMPLE_MATRIX, result);
    }
}

