/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.ProfileHelper;
import java.util.Collection;

public class UpdateFlightsParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        FlightSearchParameters flightSearchParameters = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        EntityReference techProvider = ProfileHelper.findTechnicalProviderProfile();
        Collection flights = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHTS);
        if (flights != null) {
            for (Flight flight : flights) {
                this.updateFlight(flight, (EntityContainer<BaseAirGdsAccount>)accountCtr, (EntityReference<Organization>)techProvider, flightSearchParameters);
            }
        }
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        this.updateFlight(flight, (EntityContainer<BaseAirGdsAccount>)accountCtr, (EntityReference<Organization>)techProvider, flightSearchParameters);
    }

    private void updateFlight(Flight flight, EntityContainer<BaseAirGdsAccount> accountCtr, EntityReference<Organization> techProvider, FlightSearchParameters flightSearchParameters) {
        if (flight != null) {
            if (accountCtr != null) {
                flight.setGdsAccount(accountCtr.toReference());
                flight.setGds(((BaseAirGdsAccount)accountCtr.getEntity()).getGds());
            }
            flight.setTechnicalProvider(techProvider);
            flight.setSearchParameters(flightSearchParameters);
        }
    }
}

