/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class UpdateMcoParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SalesContext sc = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (Product mco : GDSHelper.getMcoProducts(reservation)) {
            if (mco.getRelatedProducts().isEmpty()) continue;
            Product main = (Product)mco.getRelatedProducts().get(0);
            mco.setCashier(sc.getAgent());
            mco.setCashierCode(((Person)EntityStorage.get().resolve(sc.getAgent()).getEntity()).getCode());
            mco.setSalesPoint(sc.getSalesPoint());
            AirProductHelper.setSupplier((Product)mco, (EntityReference)AirProductHelper.getSupplier((Product)main));
            AirProductHelper.setAgency((Product)mco, (EntityReference)sc.getAgency());
            AirProductHelper.setSubagency((Product)mco, (EntityReference)sc.getSubagency());
            AirProductHelper.setTechnicalProvider((Product)mco, (EntityReference)sc.getTechnicalProvider());
            this.updateValue(() -> ((Product)mco).getBlankOwnerRef(), arg_0 -> ((Product)mco).setBlankOwnerRef(arg_0), main.getBlankOwnerRef());
            this.updateValue(() -> ((Product)mco).getBlankOwnerNumber(), arg_0 -> ((Product)mco).setBlankOwnerNumber(arg_0), main.getBlankOwnerNumber());
            this.updateValue(() -> ((Product)mco).getBlankType(), arg_0 -> ((Product)mco).setBlankType(arg_0), main.getBlankType());
            this.updateValue(() -> ((Product)mco).getPcc(), arg_0 -> ((Product)mco).setPcc(arg_0), main.getPcc());
            this.updateValue(() -> ((Product)mco).getValidatorCode(), arg_0 -> ((Product)mco).setValidatorCode(arg_0), main.getValidatorCode());
            this.updateValue(() -> ((Product)mco).getValidatorRef(), arg_0 -> ((Product)mco).setValidatorRef(arg_0), main.getValidatorRef());
            AirProductHelper.updateRecordNumbers((Product)mco);
            AirProductHelper.updateFops((Product)mco);
            StatisticalData mcoStatisticalData = mco.getStatisticalData();
            StatisticalData mainStatisticalData = main.getStatisticalData();
            boolean isMcoStatisticsEmpty = this.isStatisticsEmpty(mcoStatisticalData);
            boolean isMainStatisticsEmpty = this.isStatisticsEmpty(mainStatisticalData);
            if (isMainStatisticsEmpty || !isMcoStatisticsEmpty || !DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.FILL_DEFAULT_COST_CODES, (boolean)false)) continue;
            if (mcoStatisticalData == null) {
                mcoStatisticalData = new StatisticalData();
                mco.setStatisticalData(mcoStatisticalData);
            }
            mcoStatisticalData.getTravellerCostCodes().addAll(mainStatisticalData.getTravellerCostCodes());
        }
    }

    private boolean isStatisticsEmpty(StatisticalData statisticalData) {
        return statisticalData == null || statisticalData.getTravellerCostCodes().isEmpty();
    }

    private <T> void updateValue(Supplier<T> getter, Consumer<T> setter, T value) {
        this.updateValue(getter, setter, value, Objects::isNull);
    }

    private <T> void updateValue(Supplier<T> getter, Consumer<T> setter, T value, Predicate<T> isEmpty) {
        if (isEmpty.test(getter.get())) {
            setter.accept(value);
        }
    }
}

