/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class UpdateRefundProductsFopsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (Product prod : GDSHelper.getProducts(reservation, ProductCategory.AIR, ProductCategory.MCO)) {
            if (prod.getStatus() != ProductStatus.REFUND) continue;
            this.updateFops(prod);
        }
    }

    private void updateFops(Product refundProd) throws Exception {
        AirProductHelper.clearFops((Product)refundProd);
        AirProductHelper.updateFops((Product)refundProd);
        List sellCR = AirProductHelper.getContractRelations((Product)refundProd.getPreviousProduct());
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)refundProd)) {
            AirProductContractRelationData sellRelation = AirProductHelper.findContractRelation((List)sellCR, (EntityReference)item.getDescription());
            PaymentType pt = null;
            if (sellRelation != null) {
                for (ProductFop fop : sellRelation.getFops()) {
                    if (!AirProductHelper.isServiceFop((ProductFop)fop)) continue;
                    pt = fop.getType();
                    break;
                }
            }
            for (ProductFop fop : item.getFops()) {
                if (!AirProductHelper.isServiceFop((ProductFop)fop)) continue;
                fop.setOperationDate(refundProd.getIssueDate());
                fop.setType(pt);
            }
        }
    }
}

